/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.schematics;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.rendering.grid.GridQuadCache;
import ivorius.reccomplex.client.rendering.OperationRenderer;
import ivorius.reccomplex.client.rendering.SchematicQuadCache;
import ivorius.reccomplex.operation.Operation;
import ivorius.reccomplex.structures.schematics.SchematicFile;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class OperationGenerateSchematic
implements Operation {
    public SchematicFile file;
    public BlockCoord lowerCoord;
    protected GridQuadCache cachedShapeGrid;

    public OperationGenerateSchematic() {
    }

    public OperationGenerateSchematic(SchematicFile file, BlockCoord lowerCoord) {
        this.file = file;
        this.lowerCoord = lowerCoord;
    }

    @Override
    public void perform(World world) {
        this.file.generate(world, this.lowerCoord.x, this.lowerCoord.y, this.lowerCoord.z);
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        NBTTagCompound fileCompound = new NBTTagCompound();
        this.file.writeToNBT(fileCompound);
        compound.func_74782_a("schematic", (NBTBase)fileCompound);
        BlockCoord.writeCoordToNBT((String)"lowerCoord", (BlockCoord)this.lowerCoord, (NBTTagCompound)compound);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        try {
            this.file = new SchematicFile(compound.func_74775_l("schematic"));
        }
        catch (SchematicFile.UnsupportedSchematicFormatException e) {
            e.printStackTrace();
            this.file = new SchematicFile(0, 0, 0);
        }
        this.lowerCoord = BlockCoord.readCoordFromNBT((String)"lowerCoord", (NBTTagCompound)compound);
    }

    public void invalidateCache() {
        this.cachedShapeGrid = null;
    }

    @Override
    public void renderPreview(Operation.PreviewType previewType, World world, int ticks, float partialTicks) {
        int[] size = new int[]{this.file.width, this.file.height, this.file.length};
        if (previewType == Operation.PreviewType.SHAPE) {
            GL11.glColor3f((float)0.8f, (float)0.75f, (float)1.0f);
            OperationRenderer.renderGridQuadCache(this.cachedShapeGrid != null ? this.cachedShapeGrid : (this.cachedShapeGrid = SchematicQuadCache.createQuadCache(this.file, new float[]{1.0f, 1.0f, 1.0f})), AxisAlignedTransform2D.ORIGINAL, this.lowerCoord, ticks, partialTicks);
        }
        if (previewType == Operation.PreviewType.BOUNDING_BOX || previewType == Operation.PreviewType.SHAPE) {
            OperationRenderer.maybeRenderBoundingBox(this.lowerCoord, size, ticks, partialTicks);
        }
    }
}

