/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import ivorius.ivtoolkit.tools.Visitor;
import ivorius.reccomplex.utils.Algebra;
import ivorius.reccomplex.utils.ExpressionCache;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumChatFormatting;

public class PrefixedTypeExpressionCache<T>
extends ExpressionCache<T> {
    protected final SortedSet<VariableType<T>> types = new TreeSet<VariableType<T>>();

    public PrefixedTypeExpressionCache(Algebra<T> algebra, String expression) {
        super(algebra, expression);
    }

    public PrefixedTypeExpressionCache(Algebra<T> algebra, T emptyResult, String emptyResultRepresentation, String expression) {
        super(algebra, emptyResult, emptyResultRepresentation, expression);
    }

    public void addType(VariableType<T> type) {
        this.types.add(type);
    }

    public void removeType(VariableType<T> type) {
        this.types.remove(type);
    }

    public SortedSet<VariableType<T>> types() {
        return Collections.unmodifiableSortedSet(this.types);
    }

    protected VariableType<T> type(final String var) {
        return (VariableType)Iterables.find(this.types, (Predicate)new Predicate<VariableType<T>>(){

            public boolean apply(@Nullable VariableType input) {
                return var.startsWith(input.prefix);
            }
        }, null);
    }

    protected boolean isKnownVariable(String var, Object ... args) {
        VariableType<T> type = this.type(var);
        return type != null && type.isKnown(var.substring(type.prefix.length()), args);
    }

    protected T evaluateVariable(String var, Object ... args) {
        VariableType<T> type = this.type(var);
        return type != null ? (T)type.evaluate(var.substring(type.prefix.length()), args) : null;
    }

    @Override
    public boolean containsUnknownVariables() {
        return this.containsUnknownVariables(new Object[0]);
    }

    protected boolean containsUnknownVariables(final Object ... args) {
        return this.parsedExpression != null && !this.parsedExpression.walkVariables(new Visitor<String>(){

            public boolean visit(String s) {
                return PrefixedTypeExpressionCache.this.isKnownVariable(s, args);
            }
        });
    }

    protected T evaluate(final Object ... args) {
        return this.parsedExpression != null ? (T)this.parsedExpression.evaluate(new Function<String, T>(){

            public T apply(String var) {
                return PrefixedTypeExpressionCache.this.evaluateVariable(var, args);
            }
        }) : null;
    }

    @Override
    @Nonnull
    public String getDisplayString() {
        return this.getDisplayString(new Object[0]);
    }

    @Nonnull
    public String getDisplayString(final Object ... args) {
        return this.parsedExpression != null ? this.parsedExpression.toString(new Function<String, String>(){

            @Nullable
            public String apply(String input) {
                VariableType type = PrefixedTypeExpressionCache.this.type(input);
                return type != null ? type.getRepresentation(input.substring(type.prefix.length()), args) : EnumChatFormatting.RED + input;
            }
        }) : EnumChatFormatting.RED + this.expression;
    }

    public static abstract class VariableType<T>
    implements Comparable<VariableType> {
        protected String prefix;

        public VariableType(String prefix) {
            this.prefix = prefix;
        }

        public abstract T evaluate(String var1, Object ... var2);

        public abstract boolean isKnown(String var1, Object ... var2);

        public abstract String getRepresentation(String var1, Object ... var2);

        @Override
        public int compareTo(@Nonnull VariableType o) {
            return o.prefix.compareTo(this.prefix);
        }
    }
}

