/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.reccomplex.structures.StructureInfo;
import ivorius.reccomplex.structures.StructureInfos;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.utils.StructureBoundingBoxes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class StructureGenerationData
extends WorldSavedData {
    private static final String IDENTIFIER = "reccomplex:structuredata";
    protected final Set<ChunkCoordIntPair> checkedChunks = new HashSet<ChunkCoordIntPair>();
    protected final Set<ChunkCoordIntPair> checkedChunksFinal = new HashSet<ChunkCoordIntPair>();
    protected final Map<UUID, Entry> entryMap = new HashMap<UUID, Entry>();
    protected final SetMultimap<ChunkCoordIntPair, Entry> chunkMap = HashMultimap.create();
    protected final SetMultimap<String, Entry> instanceMap = HashMultimap.create();

    public StructureGenerationData(String id) {
        super(id);
    }

    public StructureGenerationData() {
        this(IDENTIFIER);
    }

    public static StructureGenerationData get(World world) {
        StructureGenerationData data = (StructureGenerationData)world.func_72943_a(StructureGenerationData.class, IDENTIFIER);
        if (data == null) {
            data = new StructureGenerationData();
            world.func_72823_a(data.field_76190_i, (WorldSavedData)data);
        }
        return data;
    }

    public Set<Entry> getEntriesAt(ChunkCoordIntPair coords, boolean onlyPartial) {
        if (onlyPartial) {
            return Sets.filter((Set)this.chunkMap.get((Object)coords), (Predicate)new Predicate<Entry>(){

                public boolean apply(Entry input) {
                    return !input.hasBeenGenerated;
                }
            });
        }
        return this.chunkMap.get((Object)coords);
    }

    public Set<Entry> getEntriesAt(final BlockCoord coords) {
        Set<Entry> entries = this.getEntriesAt(new ChunkCoordIntPair(coords.x >> 4, coords.z >> 4), false);
        return Sets.filter(entries, (Predicate)new Predicate<Entry>(){

            public boolean apply(Entry input) {
                StructureBoundingBox bb = input.boundingBox();
                return bb != null && bb.func_78890_b(coords.x, coords.y, coords.z);
            }
        });
    }

    public Set<Entry> getEntriesAt(final StructureBoundingBox boundingBox) {
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (ChunkCoordIntPair chunkCoords : StructureBoundingBoxes.rasterize(boundingBox)) {
            entries.addAll((Iterable)Sets.filter(this.getEntriesAt(chunkCoords, false), (Predicate)new Predicate<Entry>(){

                public boolean apply(Entry input) {
                    StructureBoundingBox bb = input.boundingBox();
                    return bb != null && bb.func_78884_a(boundingBox);
                }
            }));
        }
        return entries.build();
    }

    public Set<ChunkCoordIntPair> addCompleteEntry(String structureID, BlockCoord lowerCoord, AxisAlignedTransform2D transform) {
        return this.addEntry(new Entry(UUID.randomUUID(), structureID, lowerCoord, transform, true));
    }

    public Set<ChunkCoordIntPair> addGeneratingEntry(String structureID, BlockCoord lowerCoord, AxisAlignedTransform2D transform) {
        return this.addEntry(new Entry(UUID.randomUUID(), structureID, lowerCoord, transform, false));
    }

    public Set<ChunkCoordIntPair> addEntry(Entry entry) {
        this.entryMap.put(entry.getUuid(), entry);
        Set<ChunkCoordIntPair> rasterized = entry.rasterize();
        for (ChunkCoordIntPair coords : rasterized) {
            this.chunkMap.put((Object)coords, (Object)entry);
        }
        this.instanceMap.put((Object)entry.getStructureID(), (Object)entry);
        this.func_76185_a();
        return Sets.intersection(this.checkedChunksFinal, rasterized);
    }

    public Entry getEntry(UUID id) {
        return this.entryMap.get(id);
    }

    public Set<Entry> getEntriesByID(String id) {
        return this.instanceMap.get((Object)id);
    }

    public boolean checkChunk(ChunkCoordIntPair coords) {
        if (this.checkedChunks.contains(coords)) {
            return false;
        }
        this.checkedChunks.add(coords);
        this.func_76185_a();
        return true;
    }

    public boolean checkChunkFinal(ChunkCoordIntPair coords) {
        if (this.checkedChunksFinal.contains(coords)) {
            return false;
        }
        this.checkedChunksFinal.add(coords);
        this.func_76185_a();
        return true;
    }

    public void func_76184_a(NBTTagCompound compound) {
        this.entryMap.clear();
        NBTTagList entries = compound.func_150295_c("entries", 10);
        for (int i = 0; i < entries.func_74745_c(); ++i) {
            Entry entry = new Entry();
            entry.readFromNBT(entries.func_150305_b(i));
            this.addEntry(entry);
        }
    }

    public void func_76187_b(NBTTagCompound compound) {
        NBTTagList entries = new NBTTagList();
        for (Entry entry : this.entryMap.values()) {
            NBTTagCompound entryCompound = new NBTTagCompound();
            entry.writeToNBT(entryCompound);
            entries.func_74742_a((NBTBase)entryCompound);
        }
        compound.func_74782_a("entries", (NBTBase)entries);
    }

    public static class Entry {
        @Nonnull
        protected UUID uuid;
        protected String structureID;
        protected BlockCoord lowerCoord;
        protected AxisAlignedTransform2D transform;
        protected NBTTagCompound instanceData;
        protected boolean firstTime = true;
        protected boolean hasBeenGenerated;

        public Entry() {
        }

        public Entry(@Nonnull UUID uuid, String structureID, BlockCoord lowerCoord, AxisAlignedTransform2D transform, boolean hasBeenGenerated) {
            this.uuid = uuid;
            this.structureID = structureID;
            this.lowerCoord = lowerCoord;
            this.transform = transform;
            this.hasBeenGenerated = hasBeenGenerated;
        }

        @Nonnull
        public UUID getUuid() {
            return this.uuid;
        }

        public void setUuid(@Nonnull UUID uuid) {
            this.uuid = uuid;
        }

        public String getStructureID() {
            return this.structureID;
        }

        public BlockCoord getLowerCoord() {
            return this.lowerCoord;
        }

        public AxisAlignedTransform2D getTransform() {
            return this.transform;
        }

        public boolean isHasBeenGenerated() {
            return this.hasBeenGenerated;
        }

        public void readFromNBT(NBTTagCompound compound) {
            this.uuid = new UUID(compound.func_74763_f("UUIDMS"), compound.func_74763_f("UUIDLS"));
            this.structureID = compound.func_74779_i("structureID");
            this.transform = AxisAlignedTransform2D.from((int)compound.func_74762_e("rotation"), (boolean)compound.func_74767_n("mirrorX"));
            this.lowerCoord = BlockCoord.readCoordFromNBT((String)"lowerCoord", (NBTTagCompound)compound);
            if (compound.func_150297_b("instanceData", 10)) {
                this.instanceData = compound.func_74775_l("instanceData");
            }
            this.firstTime = compound.func_74767_n("firstTime");
            this.hasBeenGenerated = compound.func_74767_n("hasBeenGenerated");
        }

        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74772_a("UUIDMS", this.uuid.getMostSignificantBits());
            compound.func_74772_a("UUIDLS", this.uuid.getLeastSignificantBits());
            compound.func_74778_a("structureID", this.structureID);
            compound.func_74768_a("rotation", this.transform.getRotation());
            compound.func_74757_a("mirrorX", this.transform.isMirrorX());
            BlockCoord.writeCoordToNBT((String)"lowerCoord", (BlockCoord)this.lowerCoord, (NBTTagCompound)compound);
            if (this.instanceData != null) {
                compound.func_74782_a("instanceData", (NBTBase)this.instanceData);
            }
            compound.func_74757_a("firstTime", this.firstTime);
            compound.func_74757_a("hasBeenGenerated", this.hasBeenGenerated);
        }

        public Set<ChunkCoordIntPair> rasterize() {
            return StructureBoundingBoxes.rasterize(this.boundingBox());
        }

        public StructureBoundingBox boundingBox() {
            StructureInfo structureInfo = StructureRegistry.getStructure(this.structureID);
            return structureInfo != null ? StructureInfos.structureBoundingBox(this.lowerCoord, StructureInfos.structureSize(structureInfo, this.transform)) : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.uuid.equals(entry.uuid);
        }

        public int hashCode() {
            return this.uuid.hashCode();
        }
    }
}

