/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen.inventory;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.json.ItemStackSerializer;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.json.NbtToJson;
import ivorius.reccomplex.structures.MCRegistrySpecial;
import ivorius.reccomplex.structures.generic.matchers.DependencyMatcher;
import ivorius.reccomplex.worldgen.inventory.GenericItemCollectionRegistry;
import ivorius.reccomplex.worldgen.inventory.InventoryLoadException;
import ivorius.reccomplex.worldgen.inventory.WeightedItemCollection;
import ivorius.reccomplex.worldgen.inventory.WeightedRandomChestContentSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class GenericItemCollection
implements WeightedItemCollection {
    public static final int LATEST_VERSION = 2;
    private static Gson gson = GenericItemCollection.createGson();
    public final List<Component> components = new ArrayList<Component>();

    public static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Component.class, (Object)new Component.Serializer());
        builder.registerTypeAdapter(RandomizedItemStack.class, (Object)new RandomizedItemStack.Serializer());
        builder.registerTypeAdapter(ItemStack.class, (Object)new ItemStackSerializer(MCRegistrySpecial.INSTANCE));
        builder.registerTypeAdapter(WeightedRandomChestContent.class, (Object)new WeightedRandomChestContentSerializer());
        NbtToJson.registerSafeNBTSerializer(builder);
        return builder.create();
    }

    @Override
    public ItemStack getRandomItemStack(Random random) {
        int max = 0;
        for (Component component : this.components) {
            component.updateWeightCache();
            max += component.field_76292_a;
        }
        if (max > 0) {
            return ((Component)WeightedRandom.func_76273_a((Random)random, this.components, (int)max)).getRandomItemStack(random);
        }
        return null;
    }

    @Override
    public String getDescriptor() {
        return StatCollector.func_74838_a((String)"inventoryGen.custom");
    }

    public static class RandomizedItemStack
    implements WeightedSelector.Item {
        public ItemStack itemStack;
        public int min;
        public int max;
        public double weight;

        public RandomizedItemStack(ItemStack itemStack, int min, int max, double weight) {
            this.itemStack = itemStack;
            this.min = min;
            this.max = max;
            this.weight = weight;
        }

        public static RandomizedItemStack from(WeightedRandomChestContent chestContent, int defaultWeight) {
            return new RandomizedItemStack(chestContent.field_76297_b.func_77946_l(), chestContent.field_76295_d, chestContent.field_76296_e, (double)chestContent.field_76292_a / (double)defaultWeight);
        }

        public double getWeight() {
            return this.weight;
        }

        public static class Serializer
        implements JsonDeserializer<RandomizedItemStack>,
        JsonSerializer<RandomizedItemStack> {
            public RandomizedItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(json, "randomizedItem");
                double weight = JsonUtils.getJsonObjectDoubleFieldValue(jsonObject, "weight");
                int min = JsonUtils.getJsonObjectIntegerFieldValue(jsonObject, "min");
                int max = JsonUtils.getJsonObjectIntegerFieldValue(jsonObject, "max");
                ItemStack stack = (ItemStack)context.deserialize(jsonObject.get("item"), ItemStack.class);
                return new RandomizedItemStack(stack, min, max, weight);
            }

            public JsonElement serialize(RandomizedItemStack src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("weight", (Number)src.weight);
                jsonObject.addProperty("min", (Number)src.min);
                jsonObject.addProperty("max", (Number)src.max);
                jsonObject.add("item", context.serialize((Object)src.itemStack));
                return jsonObject;
            }
        }
    }

    public static class Component
    extends WeightedRandom.Item {
        public final List<RandomizedItemStack> items = new ArrayList<RandomizedItemStack>();
        public final DependencyMatcher dependencies = new DependencyMatcher("");
        public String inventoryGeneratorID;

        public Component() {
            super(0);
            this.inventoryGeneratorID = "";
        }

        public Component(String inventoryGeneratorID, List<RandomizedItemStack> items, String dependencies) {
            super(0);
            this.inventoryGeneratorID = inventoryGeneratorID;
            this.items.addAll(items);
            this.dependencies.setExpression(dependencies);
        }

        public static Component createDefaultComponent() {
            return new Component();
        }

        public ItemStack getRandomItemStack(Random random) {
            if (this.items.size() == 0) {
                return null;
            }
            RandomizedItemStack item = (RandomizedItemStack)WeightedSelector.selectItem((Random)random, this.items);
            ItemStack[] stacks = ChestGenHooks.generateStacks((Random)random, (ItemStack)item.itemStack, (int)item.min, (int)item.max);
            return stacks.length > 0 ? stacks[0] : null;
        }

        public boolean areDependenciesResolved() {
            return this.dependencies.apply();
        }

        public void updateWeightCache() {
            this.field_76292_a = this.items.size();
        }

        public Component copy() {
            try {
                return GenericItemCollectionRegistry.createComponentFromJSON(GenericItemCollectionRegistry.createJSONFromComponent(this));
            }
            catch (InventoryLoadException e) {
                e.printStackTrace();
                return null;
            }
        }

        public static class Serializer
        implements JsonDeserializer<Component>,
        JsonSerializer<Component> {
            public Component deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
                int version;
                JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(jsonElement, "status");
                if (jsonObject.has("version")) {
                    version = JsonUtils.getJsonObjectIntegerFieldValue(jsonObject, "version");
                } else {
                    version = 2;
                    RecurrentComplex.logger.warn("InventoryGen JSON missing 'version', using latest (2)");
                }
                String generatorID = JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "inventoryGeneratorID", "");
                ArrayList<RandomizedItemStack> stacks = new ArrayList<RandomizedItemStack>();
                if (jsonObject.has("items")) {
                    stacks.addAll(Lists.newArrayList((Object[])((Object[])gson.fromJson(jsonObject.get("items"), RandomizedItemStack[].class))));
                }
                if (version == 1 && jsonObject.has("contents")) {
                    ArrayList chestContents = Lists.newArrayList((Object[])((Object[])gson.fromJson(jsonObject.get("contents"), WeightedRandomChestContent[].class)));
                    stacks.addAll(Collections2.transform((Collection)chestContents, (Function)new Function<WeightedRandomChestContent, RandomizedItemStack>(){

                        @Nullable
                        public RandomizedItemStack apply(WeightedRandomChestContent input) {
                            return RandomizedItemStack.from(input, 100);
                        }
                    }));
                }
                String dependencyExpression = JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "dependencyExpression", "");
                if (version == 1 && jsonObject.has("dependencies")) {
                    String[] dependencies = (String[])context.deserialize(jsonObject.get("dependencies"), String[].class);
                    dependencyExpression = DependencyMatcher.ofMods(dependencies);
                }
                return new Component(generatorID, stacks, dependencyExpression);
            }

            public JsonElement serialize(Component src, Type par2Type, JsonSerializationContext context) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("version", (Number)2);
                jsonObject.addProperty("inventoryGeneratorID", src.inventoryGeneratorID);
                jsonObject.add("items", gson.toJsonTree(src.items));
                jsonObject.add("dependencyExpression", context.serialize((Object)src.dependencies.getExpression()));
                return jsonObject;
            }
        }
    }
}

