/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen.inventory;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.json.NbtToJson;
import ivorius.reccomplex.worldgen.inventory.GenericItemCollection;
import ivorius.reccomplex.worldgen.inventory.InventoryLoadException;
import ivorius.reccomplex.worldgen.inventory.ItemCollectionSaveHandler;
import ivorius.reccomplex.worldgen.inventory.WeightedItemCollection;
import ivorius.reccomplex.worldgen.inventory.WeightedItemCollectionRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;

public class GenericItemCollectionRegistry {
    private static Map<String, GenericItemCollection.Component> allComponents = new HashMap<String, GenericItemCollection.Component>();
    private static Map<String, String> componentDomains = Maps.newHashMap();
    private static Set<String> persistentlyDisabledComponents = new HashSet<String>();
    private static Set<String> generatingComponents = new HashSet<String>();
    private static Gson gson = GenericItemCollectionRegistry.createGson();

    public static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(GenericItemCollection.Component.class, (Object)new GenericItemCollection.Component.Serializer());
        NbtToJson.registerSafeNBTSerializer(builder);
        return builder.create();
    }

    public static boolean register(GenericItemCollection.Component component, String key, String domain, boolean generates) {
        if (RCConfig.shouldInventoryGeneratorLoad(key, domain)) {
            if (!generates) {
                persistentlyDisabledComponents.add(key);
            } else {
                persistentlyDisabledComponents.remove(key);
            }
            String baseString = allComponents.containsKey(key) ? "Replaced inventory generation component '%s'" : "Registered generation component '%s'";
            RecurrentComplex.logger.info(String.format(baseString, key));
            allComponents.put(key, component);
            componentDomains.put(key, domain);
            GenericItemCollectionRegistry.clearCaches();
            return true;
        }
        return false;
    }

    public static GenericItemCollection.Component component(String key) {
        return allComponents.get(key);
    }

    public static Set<String> allComponentKeys() {
        return Collections.unmodifiableSet(allComponents.keySet());
    }

    public static void removeGenerator(String key) {
        allComponents.remove(key);
        GenericItemCollectionRegistry.clearCaches();
    }

    public static boolean register(ResourceLocation resourceLocation, String key, boolean generates) {
        GenericItemCollection.Component component = ItemCollectionSaveHandler.readInventoryGenerator(resourceLocation);
        return component != null && GenericItemCollectionRegistry.register(component, key, resourceLocation.func_110624_b(), generates);
    }

    public static boolean isLoaded(String key) {
        return allComponents.containsKey(key);
    }

    public static boolean isActive(String key) {
        return generatingComponents.contains(key);
    }

    public static String createJSONFromComponent(GenericItemCollection.Component inventoryGenerator) {
        return gson.toJson((Object)inventoryGenerator, GenericItemCollection.Component.class);
    }

    public static GenericItemCollection.Component createComponentFromJSON(String json) throws InventoryLoadException {
        try {
            return (GenericItemCollection.Component)((Object)gson.fromJson(json, GenericItemCollection.Component.class));
        }
        catch (JsonSyntaxException e) {
            throw new InventoryLoadException(e);
        }
    }

    private static void clearCaches() {
        WeightedItemCollection collection;
        GenericItemCollection.Component component;
        HashSet<String> newGeneratingComponents = new HashSet<String>();
        for (Map.Entry<String, GenericItemCollection.Component> entry : allComponents.entrySet()) {
            component = entry.getValue();
            String key = entry.getKey();
            if (persistentlyDisabledComponents.contains(key) || !RCConfig.shouldInventoryGeneratorGenerate(key, componentDomains.get(key)) || !component.areDependenciesResolved()) continue;
            newGeneratingComponents.add(key);
        }
        for (String key : Sets.difference(newGeneratingComponents, generatingComponents)) {
            component = allComponents.get(key);
            collection = GenericItemCollectionRegistry.registerGetGenericItemCollection(component.inventoryGeneratorID);
            collection.components.add(component);
            generatingComponents.add(key);
        }
        for (String key : Sets.difference(generatingComponents, newGeneratingComponents)) {
            component = allComponents.get(key);
            collection = WeightedItemCollectionRegistry.itemCollection(component.inventoryGeneratorID);
            if (!(collection instanceof GenericItemCollection)) continue;
            collection.components.remove((Object)component);
            if (collection.components.size() != 0) continue;
            WeightedItemCollectionRegistry.unregister(component.inventoryGeneratorID);
        }
        generatingComponents = newGeneratingComponents;
    }

    private static GenericItemCollection registerGetGenericItemCollection(String key) {
        WeightedItemCollection collection = WeightedItemCollectionRegistry.itemCollection(key);
        if (collection == null || !(collection instanceof GenericItemCollection)) {
            collection = new GenericItemCollection();
            WeightedItemCollectionRegistry.register(collection, key);
        }
        return (GenericItemCollection)collection;
    }
}

