/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen.villages;

import cpw.mods.fml.common.registry.VillagerRegistry;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.reccomplex.structures.StructureInfo;
import ivorius.reccomplex.structures.StructureInfos;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.structures.generic.gentypes.StructureGenerationInfo;
import ivorius.reccomplex.structures.generic.gentypes.VanillaStructureGenerationInfo;
import ivorius.reccomplex.worldgen.villages.GenericVillagePiece;
import ivorius.reccomplex.worldgen.villages.VanillaGenerationClassFactory;
import java.util.List;
import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public class GenericVillageCreationHandler
implements VillagerRegistry.IVillageCreationHandler {
    protected String structureID;
    protected String generationID;

    public GenericVillageCreationHandler(String structureID, String generationID) {
        this.structureID = structureID;
        this.generationID = generationID;
    }

    public static GenericVillageCreationHandler forGeneration(String structureID, String generationID) {
        return GenericVillageCreationHandler.getPieceClass(structureID, generationID) != null ? new GenericVillageCreationHandler(structureID, generationID) : null;
    }

    public static Class<? extends GenericVillagePiece> getPieceClass(String structureID, String generationID) {
        return VanillaGenerationClassFactory.instance().getClass(structureID, generationID);
    }

    public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random random, int villageSize) {
        StructureGenerationInfo generationInfo;
        StructureInfo structureInfo;
        StructureInfo structureInfo2 = structureInfo = StructureRegistry.isStructureGenerating(this.structureID) ? StructureRegistry.getStructure(this.structureID) : null;
        if (structureInfo != null && (generationInfo = structureInfo.generationInfo(this.generationID)) instanceof VanillaStructureGenerationInfo) {
            VanillaStructureGenerationInfo vanillaGenInfo = (VanillaStructureGenerationInfo)generationInfo;
            int spawnLimit = MathHelper.func_76128_c((double)(MathHelper.func_82716_a((Random)random, (double)(vanillaGenInfo.minBaseLimit + (double)villageSize * vanillaGenInfo.minScaledLimit), (double)(vanillaGenInfo.maxBaseLimit + (double)villageSize * vanillaGenInfo.maxScaledLimit)) + 0.5));
            return new StructureVillagePieces.PieceWeight(this.getComponentClass(), vanillaGenInfo.getVanillaWeight(), spawnLimit);
        }
        return new StructureVillagePieces.PieceWeight(this.getComponentClass(), 0, 0);
    }

    public Class<?> getComponentClass() {
        return GenericVillageCreationHandler.getPieceClass(this.structureID, this.generationID);
    }

    public Object buildComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start start, List components, Random random, int x, int y, int z, int front, int generationDepth) {
        StructureGenerationInfo generationInfo;
        StructureInfo structureInfo = StructureRegistry.getStructure(this.structureID);
        if (structureInfo != null && (generationInfo = structureInfo.generationInfo(this.generationID)) instanceof VanillaStructureGenerationInfo) {
            VanillaStructureGenerationInfo vanillaGenInfo = (VanillaStructureGenerationInfo)generationInfo;
            boolean mirrorX = structureInfo.isMirrorable() && random.nextBoolean();
            AxisAlignedTransform2D transform = GenericVillagePiece.getTransform(vanillaGenInfo, front, mirrorX);
            if (vanillaGenInfo.generatesIn(start.biome) && structureInfo.isRotatable() || transform.getRotation() == 0) {
                GenericVillagePiece genericVillagePiece;
                int[] structureSize = StructureInfos.structureSize(structureInfo, transform);
                BlockCoord structureShift = new BlockCoord(0, 0, 0);
                StructureBoundingBox strucBB = StructureInfos.structureBoundingBox(structureShift, structureSize);
                int derotatedX = front % 2 == 0 ? strucBB.func_78883_b() : strucBB.func_78880_d();
                int derotatedZ = front % 2 == 1 ? strucBB.func_78883_b() : strucBB.func_78880_d();
                if (GenericVillagePiece.canVillageGoDeeperC(strucBB = StructureBoundingBox.func_78889_a((int)(x + strucBB.field_78897_a), (int)(y + strucBB.field_78895_b), (int)(z + strucBB.field_78896_c), (int)0, (int)0, (int)0, (int)derotatedX, (int)strucBB.func_78882_c(), (int)derotatedZ, (int)front)) && StructureComponent.func_74883_a((List)components, (StructureBoundingBox)strucBB) == null && (genericVillagePiece = GenericVillagePiece.create(this.structureID, this.generationID, start, generationDepth)) != null) {
                    strucBB.func_78886_a(structureShift.x, structureShift.y, structureShift.z);
                    genericVillagePiece.setIds(this.structureID, this.generationID);
                    genericVillagePiece.setOrientation(front, mirrorX, strucBB);
                    genericVillagePiece.prepare(random);
                    return genericVillagePiece;
                }
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericVillageCreationHandler that = (GenericVillageCreationHandler)o;
        if (!this.structureID.equals(that.structureID)) {
            return false;
        }
        return this.generationID.equals(that.generationID);
    }

    public int hashCode() {
        int result = this.structureID.hashCode();
        result = 31 * result + this.generationID.hashCode();
        return result;
    }
}

