/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.registry.IWailaTooltipHandler;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.integration.IntegrationModule;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class Waila
extends IntegrationModule {
    @Override
    public String getModID() {
        return "Waila";
    }

    @Override
    public void init() throws Throwable {
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"com.jaquadro.minecraft.storagedrawers.integration.Waila.registerProvider");
    }

    @Override
    public void postInit() {
    }

    public static void registerProvider(IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)new WailaDrawer(), BlockDrawers.class);
    }

    public static class WailaDrawer
    implements IWailaDataProvider {
        public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return null;
        }

        public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return currenttip;
        }

        public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            TileEntityDrawers tile;
            TileEntityDrawers group = tile = (TileEntityDrawers)accessor.getTileEntity();
            for (int i = 0; i < group.getDrawerCount(); ++i) {
                if (!group.isDrawerEnabled(i)) continue;
                String name = StatCollector.func_74838_a((String)"storageDrawers.waila.empty");
                IDrawer drawer = group.getDrawer(i);
                ItemStack stack = drawer.getStoredItemPrototype();
                if (stack != null && stack.func_77973_b() != null) {
                    String stackName = stack.func_82833_r();
                    List<IWailaTooltipHandler> handlers = StorageDrawers.wailaRegistry.getTooltipHandlers();
                    int n = handlers.size();
                    for (int j = 0; j < n; ++j) {
                        stackName = handlers.get(j).transformItemName(drawer, stackName);
                    }
                    name = drawer instanceof IFractionalDrawer && ((IFractionalDrawer)drawer).getConversionRate() > 1 ? stackName + (i == 0 ? " [" : " [+") + ((IFractionalDrawer)drawer).getStoredItemRemainder() + "]" : stackName + " [" + drawer.getStoredItemCount() + "]";
                }
                currenttip.add(StatCollector.func_74837_a((String)"storageDrawers.waila.drawer", (Object[])new Object[]{i + 1, name}));
            }
            String attrib = "";
            if (tile.isLocked(LockAttribute.LOCK_POPULATED)) {
                attrib = attrib + (attrib.isEmpty() ? "" : ", ") + StatCollector.func_74838_a((String)"storageDrawers.waila.locked");
            }
            if (tile.isVoid()) {
                attrib = attrib + (attrib.isEmpty() ? "" : ", ") + StatCollector.func_74838_a((String)"storageDrawers.waila.void");
            }
            if (tile.isSorting()) {
                attrib = attrib + (attrib.isEmpty() ? "" : ", ") + StatCollector.func_74838_a((String)"storageDrawers.waila.sorting");
            }
            if (!attrib.isEmpty()) {
                currenttip.add(attrib);
            }
            return currenttip;
        }

        public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return currenttip;
        }

        public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
            return null;
        }
    }
}

