/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration.minetweaker;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.storagedrawers.Compaction")
public class Compaction {
    @ZenMethod
    public static void add(IItemStack upper, IItemStack lower, int conversion) {
        ItemStack upperStack = MineTweakerMC.getItemStack((IItemStack)upper);
        ItemStack lowerStack = MineTweakerMC.getItemStack((IItemStack)lower);
        if (upperStack == null || lowerStack == null) {
            MineTweakerAPI.logError((String)"Tried to add compacting tier with invalid item stack.");
        } else if (conversion != 4 && conversion != 9) {
            MineTweakerAPI.logError((String)"Tried to add compacting tier with invalid conversion value (must be 4 or 9).");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddRecordAction(upperStack, lowerStack, conversion));
        }
    }

    private static class AddRecordAction
    implements IUndoableAction {
        ItemStack upper;
        ItemStack lower;
        int conversionRate;
        boolean added;

        public AddRecordAction(ItemStack upper, ItemStack lower, int conversionRate) {
            this.upper = upper;
            this.lower = lower;
            this.conversionRate = conversionRate;
        }

        public void apply() {
            this.added = StorageDrawers.compRegistry.register(this.upper, this.lower, this.conversionRate);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            if (this.added) {
                StorageDrawers.compRegistry.unregisterUpperTarget(this.upper);
            }
        }

        public String describe() {
            if (this.added) {
                return "Adding compacting tier: 1 '" + this.upper.func_82833_r() + "' = " + this.conversionRate + " '" + this.lower.func_82833_r() + "'.";
            }
            return "Failed to add compacting tier.";
        }

        public String describeUndo() {
            if (this.added) {
                return "Removing previously added compacting tier: 1 '" + this.upper.func_82833_r() + "' = " + this.conversionRate + " '" + this.lower.func_82833_r() + "'.";
            }
            return "";
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

