/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.api.core.IStructureLogic;
import forestry.api.core.ITileStructure;
import forestry.core.gadgets.BlockStructure;
import forestry.core.utils.Schemata;
import forestry.core.vect.Vect;
import java.util.EnumMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public abstract class StructureLogic
implements IStructureLogic {
    protected final ITileStructure structure;
    protected final TileEntity structureTile;
    protected final String uid;
    protected Schemata[] schematas;
    protected short activeSchemata = (short)-1;
    protected boolean isRotated = false;
    protected EnumMap<Schemata.EnumStructureBlock, Integer> metaOnValid = new EnumMap(Schemata.EnumStructureBlock.class);

    public StructureLogic(String uid, ITileStructure structure) {
        this.uid = uid;
        this.structure = structure;
        this.structureTile = (TileEntity)structure;
    }

    @Override
    public String getTypeUID() {
        return this.uid;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.func_74764_b("SchemataOrdinal")) {
            this.activeSchemata = nbttagcompound.func_74765_d("SchemataOrdinal");
        }
        this.isRotated = nbttagcompound.func_74767_n("Rotated");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        if (this.activeSchemata >= 0) {
            nbttagcompound.func_74777_a("SchemataOrdinal", this.activeSchemata);
        }
        nbttagcompound.func_74757_a("Rotated", this.isRotated);
    }

    @Override
    public void validateStructure() {
        ITileStructure master = this.structure.getCentralTE();
        if (!this.structure.isMaster() && master != null) {
            master.validateStructure();
            return;
        }
        BlockStructure.EnumStructureState state = BlockStructure.EnumStructureState.INDETERMINATE;
        for (int i = 0; i < this.schematas.length; ++i) {
            if (!this.schematas[i].isEnabled()) continue;
            state = this.determineMasterState(this.schematas[i], false);
            boolean rotate = false;
            if (state == BlockStructure.EnumStructureState.INVALID && this.schematas[i].getWidth() != this.schematas[i].getDepth()) {
                state = this.determineMasterState(this.schematas[i], true);
                rotate = true;
            }
            if (state != BlockStructure.EnumStructureState.VALID) continue;
            this.activeSchemata = (short)i;
            this.isRotated = rotate;
            break;
        }
        if (state == BlockStructure.EnumStructureState.INDETERMINATE) {
            return;
        }
        if (state == BlockStructure.EnumStructureState.VALID) {
            if (!this.structure.isMaster()) {
                this.structure.makeMaster();
                this.markStructureBlocks(this.schematas[this.activeSchemata]);
            }
        } else if (this.structure.isMaster()) {
            this.resetStructureBlocks(this.schematas[this.activeSchemata]);
        }
    }

    protected void resetStructureBlocks(Schemata schemata) {
        Vect dimensions = schemata.getDimensions(this.isRotated);
        int offsetX = schemata.getxOffset();
        int offsetZ = schemata.getzOffset();
        if (this.isRotated) {
            offsetX = schemata.getzOffset();
            offsetZ = schemata.getxOffset();
        }
        for (int i = 0; i < dimensions.x; ++i) {
            for (int j = 0; j < schemata.getHeight(); ++j) {
                for (int k = 0; k < dimensions.z; ++k) {
                    ITileStructure part;
                    int x = this.structureTile.field_145851_c + i + offsetX;
                    int y = this.structureTile.field_145848_d + j + schemata.getyOffset();
                    int z = this.structureTile.field_145849_e + k + offsetZ;
                    TileEntity tile = this.structureTile.func_145831_w().func_147438_o(x, y, z);
                    if (!(tile instanceof ITileStructure) || !(part = (ITileStructure)tile).getTypeUID().equals(this.getTypeUID())) continue;
                    part.onStructureReset();
                }
            }
        }
    }

    protected void markStructureBlocks(Schemata schemata) {
        Vect dimensions = schemata.getDimensions(this.isRotated);
        int offsetX = schemata.getxOffset();
        int offsetZ = schemata.getzOffset();
        if (this.isRotated) {
            offsetX = schemata.getzOffset();
            offsetZ = schemata.getxOffset();
        }
        for (int i = 0; i < dimensions.x; ++i) {
            for (int j = 0; j < schemata.getHeight(); ++j) {
                for (int k = 0; k < dimensions.z; ++k) {
                    ITileStructure part;
                    int x = this.structureTile.field_145851_c + i + offsetX;
                    int y = this.structureTile.field_145848_d + j + schemata.getyOffset();
                    int z = this.structureTile.field_145849_e + k + offsetZ;
                    TileEntity tile = this.structureTile.func_145831_w().func_147438_o(x, y, z);
                    if (!(tile instanceof ITileStructure) || !(part = (ITileStructure)tile).getTypeUID().equals(this.getTypeUID())) continue;
                    part.setCentralTE((TileEntity)this.structure);
                    Schemata.EnumStructureBlock type = schemata.getAt(i, j, k, this.isRotated);
                    if (!this.metaOnValid.containsKey((Object)type)) continue;
                    this.structureTile.func_145831_w().func_72921_c(x, y, z, this.metaOnValid.get((Object)type).intValue(), 2);
                    this.structureTile.func_145831_w().func_147471_g(x, y, z);
                }
            }
        }
    }

    protected abstract BlockStructure.EnumStructureState determineMasterState(Schemata var1, boolean var2);
}

