/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.ForestryPacket;
import forestry.core.network.ILocatedPacket;
import forestry.core.network.PacketId;
import java.io.IOException;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class PacketCoordinates
extends ForestryPacket
implements ILocatedPacket {
    private int posX;
    private int posY;
    private int posZ;

    public PacketCoordinates(DataInputStreamForestry data) throws IOException {
        super(data);
    }

    public PacketCoordinates(PacketId id, TileEntity tileEntity) {
        this(id, tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
    }

    public PacketCoordinates(PacketId id, ChunkCoordinates coordinates) {
        this(id, coordinates.field_71574_a, coordinates.field_71572_b, coordinates.field_71573_c);
    }

    public PacketCoordinates(PacketId id, int posX, int posY, int posZ) {
        super(id);
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeVarInt(this.posX);
        data.writeVarInt(this.posY);
        data.writeVarInt(this.posZ);
    }

    @Override
    protected void readData(DataInputStreamForestry data) throws IOException {
        this.posX = data.readVarInt();
        this.posY = data.readVarInt();
        this.posZ = data.readVarInt();
    }

    public final ChunkCoordinates getCoordinates() {
        return new ChunkCoordinates(this.posX, this.posY, this.posZ);
    }

    @Override
    public final int getPosX() {
        return this.posX;
    }

    @Override
    public final int getPosY() {
        return this.posY;
    }

    @Override
    public final int getPosZ() {
        return this.posZ;
    }

    @Override
    public final TileEntity getTarget(World world) {
        return world.func_147438_o(this.posX, this.posY, this.posZ);
    }
}

