/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming;

import forestry.api.core.IStructureLogic;
import forestry.api.farming.IFarmComponent;
import forestry.api.farming.IFarmInterface;
import forestry.core.vect.MutableVect;
import forestry.core.vect.Vect;
import forestry.core.vect.VectUtil;
import forestry.farming.gadgets.StructureLogicFarm;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class FarmHelper
implements IFarmInterface {
    @Override
    public IStructureLogic createFarmStructureLogic(IFarmComponent structure) {
        return new StructureLogicFarm(structure);
    }

    public static int getFarmSizeNorthSouth(World world, Vect start) {
        ForgeDirection farmSide = ForgeDirection.NORTH;
        ForgeDirection startSide = ForgeDirection.EAST;
        Vect corner = FarmHelper.getFarmMultiblockCorner(world, start, farmSide, startSide);
        return FarmHelper.getFarmSizeInDirection(world, corner, farmSide, startSide.getOpposite());
    }

    public static int getFarmSizeEastWest(World world, Vect start) {
        ForgeDirection farmSide = ForgeDirection.EAST;
        ForgeDirection startSide = ForgeDirection.NORTH;
        Vect corner = FarmHelper.getFarmMultiblockCorner(world, start, farmSide, startSide);
        return FarmHelper.getFarmSizeInDirection(world, corner, farmSide, startSide.getOpposite());
    }

    private static int getFarmSizeInDirection(World world, Vect start, ForgeDirection farmSide, ForgeDirection searchDirection) {
        Vect farmTileLocation;
        TileEntity farmTile;
        int size = 0;
        ForgeDirection toCenter = farmSide.getOpposite();
        Vect target = start.add(farmSide);
        do {
            ++size;
        } while ((farmTile = VectUtil.getTile(world, farmTileLocation = (target = target.add(searchDirection)).add(toCenter))) instanceof IFarmComponent);
        return size;
    }

    public static Vect getFarmMultiblockCorner(World world, Vect start, ForgeDirection direction1, ForgeDirection direction2) {
        Vect edge = FarmHelper.getFarmMultiblockEdge(world, start, direction1);
        return FarmHelper.getFarmMultiblockEdge(world, edge, direction2);
    }

    private static Vect getFarmMultiblockEdge(World world, Vect start, ForgeDirection direction) {
        MutableVect edge = new MutableVect(start);
        while (VectUtil.getTile(world, edge) instanceof IFarmComponent) {
            edge.add(direction);
        }
        edge.add(direction.getOpposite());
        return new Vect(edge);
    }
}

