/*
 * Decompiled with CFR 0.152.
 */
package forestry.pipes.network;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketId;
import java.io.IOException;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketGenomeFilterChange
extends PacketCoordinates {
    private int orientation;
    private int pattern;
    private int allele;
    private String species;

    public PacketGenomeFilterChange(DataInputStreamForestry data) throws IOException {
        super(data);
    }

    public PacketGenomeFilterChange(TileEntity tile, ForgeDirection orientation, int pattern, int allele, IAllele species) {
        super(PacketId.PROP_SEND_FILTER_CHANGE_GENOME, tile);
        this.orientation = orientation.ordinal();
        this.pattern = pattern;
        this.allele = allele;
        this.species = species != null ? species.getUID() : "";
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeShort(this.orientation);
        data.writeShort(this.pattern);
        data.writeShort(this.allele);
        data.writeUTF(this.species);
    }

    @Override
    protected void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.orientation = data.readShort();
        this.pattern = data.readShort();
        this.allele = data.readShort();
        this.species = data.readUTF();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getPattern() {
        return this.pattern;
    }

    public int getAllele() {
        return this.allele;
    }

    public IAllele getSpecies() {
        if (this.species.length() == 0) {
            return null;
        }
        return AlleleManager.alleleRegistry.getAllele(this.species);
    }
}

