/*
 * Decompiled with CFR 0.152.
 */
package neresources.api.messages;

import neresources.api.messages.ModifyMessage;
import neresources.api.messages.utils.MessageHelper;
import neresources.api.utils.PlantDrop;
import neresources.api.utils.Priority;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ModifyPlantMessage
extends ModifyMessage {
    private ItemStack plant;
    private PlantDrop[] addDrops = new PlantDrop[0];
    private ItemStack[] removeDrops = new ItemStack[0];

    private ModifyPlantMessage(ItemStack plant, Priority priority, boolean add) {
        super(priority, add);
        this.plant = plant;
    }

    private ModifyPlantMessage(ItemStack plant, Priority addPriority, Priority removePriority) {
        super(addPriority, removePriority);
        this.plant = plant;
    }

    public ModifyPlantMessage(PlantDrop ... addDrops) {
        this(new ItemStack((Block)Blocks.field_150329_H), addDrops);
    }

    public ModifyPlantMessage(ItemStack plant, PlantDrop ... addDrops) {
        this(plant, Priority.SECOND, addDrops);
    }

    public ModifyPlantMessage(ItemStack plant, Priority priority, PlantDrop ... addDrops) {
        this(plant, priority, true, new ItemStack[0], addDrops);
    }

    public ModifyPlantMessage(ItemStack ... removeDrops) {
        this(new ItemStack((Block)Blocks.field_150329_H), removeDrops);
    }

    public ModifyPlantMessage(ItemStack plant, ItemStack ... removeDrops) {
        this(plant, Priority.SECOND, removeDrops);
    }

    public ModifyPlantMessage(ItemStack plant, Priority priority, ItemStack ... removeDrops) {
        this(plant, priority, false, removeDrops, new PlantDrop[0]);
    }

    public ModifyPlantMessage(ItemStack plant, Priority priority, boolean add, ItemStack[] removeDrops, PlantDrop[] addDrops) {
        this(plant, priority, add);
        this.addDrops = addDrops;
        this.removeDrops = removeDrops;
    }

    public ModifyPlantMessage(ItemStack plant, ItemStack[] removeDrops, PlantDrop[] addDrops) {
        this(plant, removeDrops, addDrops, Priority.SECOND);
    }

    public ModifyPlantMessage(ItemStack plant, ItemStack[] removeDrops, PlantDrop[] addDrops, Priority priority) {
        this(plant, removeDrops, addDrops, priority, priority);
    }

    public ModifyPlantMessage(ItemStack plant, ItemStack[] removeDrops, PlantDrop[] addDrops, Priority addPriority, Priority removePriority) {
        this(plant, addPriority, removePriority);
        this.addDrops = addDrops;
        this.removeDrops = removeDrops;
    }

    public ModifyPlantMessage(NBTTagCompound tagCompound) {
        super(tagCompound);
        this.plant = ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("stack"));
        this.addDrops = MessageHelper.getPlantDrops(tagCompound, "addDrops");
        this.removeDrops = MessageHelper.getItemStacks(tagCompound, "removeDrops");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74782_a("stack", (NBTBase)this.plant.func_77955_b(new NBTTagCompound()));
        tagCompound.func_74782_a("addDrops", (NBTBase)MessageHelper.getPlantDropList(this.addDrops));
        tagCompound.func_74782_a("removeDrops", (NBTBase)MessageHelper.getItemStackList(this.removeDrops));
        return tagCompound;
    }

    @Override
    public boolean hasAdd() {
        return this.addDrops.length > 0;
    }

    @Override
    public boolean hasRemove() {
        return this.removeDrops.length > 0;
    }

    @Override
    public boolean isValid() {
        return this.plant != null && (this.hasAdd() || this.hasRemove());
    }
}

