/*
 * Decompiled with CFR 0.152.
 */
package neresources.compatibility.minecraft;

import java.util.HashMap;
import neresources.api.distributions.DistributionBase;
import neresources.api.distributions.DistributionSquare;
import neresources.api.distributions.DistributionTriangular;
import neresources.api.distributions.DistributionUnderWater;
import neresources.api.messages.ModifyOreMessage;
import neresources.api.messages.RegisterOreMessage;
import neresources.api.utils.DropItem;
import neresources.api.utils.LightLevel;
import neresources.api.utils.PlantDrop;
import neresources.api.utils.Priority;
import neresources.api.utils.conditionals.Conditional;
import neresources.compatibility.CompatBase;
import neresources.compatibility.cofh.CoFHCompat;
import neresources.entries.MobEntry;
import neresources.entries.PlantEntry;
import neresources.registry.DungeonRegistry;
import neresources.registry.MessageRegistry;
import neresources.utils.ReflectionHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.MonsterHelper;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ChestGenHooks;

public class MinecraftCompat
extends CompatBase {
    @Override
    protected void init() {
        this.registerVanillaMobs();
        this.registerDungeonLoot();
        if (!CoFHCompat.cofhReplace) {
            this.registerOres();
        }
        this.registerVanillaOreDrops();
        this.registerVanillaPlants();
    }

    private void registerVanillaOreDrops() {
        this.registerOre(new RegisterOreMessage(new ItemStack(Blocks.field_150435_aG), (DistributionBase)new DistributionUnderWater(0.0035f), new ItemStack(Items.field_151119_aD, 4)));
        MessageRegistry.addMessage(new ModifyOreMessage(new ItemStack(Blocks.field_150435_aG), Priority.FIRST, new ItemStack(Items.field_151119_aD, 4)));
        MessageRegistry.addMessage(new ModifyOreMessage(new ItemStack(Blocks.field_150365_q), Priority.FIRST, new ItemStack(Items.field_151044_h)));
        MessageRegistry.addMessage(new ModifyOreMessage(new ItemStack(Blocks.field_150482_ag), Priority.FIRST, new ItemStack(Items.field_151045_i)));
        MessageRegistry.addMessage(new ModifyOreMessage(new ItemStack(Blocks.field_150369_x), Priority.FIRST, new ItemStack(Items.field_151100_aR, 4, 4)));
        MessageRegistry.addMessage(new ModifyOreMessage(new ItemStack(Blocks.field_150412_bA), Priority.FIRST, new ItemStack(Items.field_151166_bC)));
        MessageRegistry.addMessage(new ModifyOreMessage(new ItemStack(Blocks.field_150450_ax), Priority.FIRST, new ItemStack(Items.field_151137_ax, 4)));
    }

    private void registerVanillaMobs() {
        DropItem ironIngot = new DropItem(Items.field_151042_j, 3, 5, new Conditional[0]);
        DropItem poppy = new DropItem(new ItemStack((Block)Blocks.field_150328_O), 0, 2, new Conditional[0]);
        this.registerMob(new MobEntry((EntityLivingBase)new EntityIronGolem(world), LightLevel.any, ironIngot, poppy));
        DropItem snowball = new DropItem(Items.field_151126_ay, 0, 15, new Conditional[0]);
        this.registerMob(new MobEntry((EntityLivingBase)new EntitySnowman(world), LightLevel.any, snowball));
        DropItem leather = new DropItem(Items.field_151116_aA, 0, 2, new Conditional[0]);
        DropItem beef = new DropItem(Items.field_151082_bd, 1, 3, new Conditional[0]);
        DropItem steak = new DropItem(Items.field_151083_be, 1, 3, Conditional.burning);
        this.registerMob(new MobEntry((EntityLivingBase)new EntityCow(world), LightLevel.any, leather, beef, steak));
        this.registerMob(new MobEntry((EntityLivingBase)new EntityMooshroom(world), LightLevel.any, leather, beef, steak));
        DropItem feather = new DropItem(Items.field_151008_G, 0, 2, new Conditional[0]);
        DropItem chicken = new DropItem(Items.field_151076_bf, 1, 1, new Conditional[0]);
        DropItem cookedchicken = new DropItem(Items.field_151077_bg, 1, 1, Conditional.burning);
        this.registerMob(new MobEntry((EntityLivingBase)new EntityChicken(world), LightLevel.any, feather, chicken, cookedchicken));
        DropItem pork = new DropItem(Items.field_151147_al, 1, 3, new Conditional[0]);
        DropItem cookedpork = new DropItem(Items.field_151157_am, 1, 3, Conditional.burning);
        this.registerMob(new MobEntry((EntityLivingBase)new EntityPig(world), LightLevel.any, pork, cookedpork));
        DropItem wool = new DropItem(new ItemStack(Blocks.field_150325_L), 1, 1, new Conditional[0]);
        this.registerMob(new MobEntry((EntityLivingBase)new EntitySheep(world), LightLevel.any, wool));
        DropItem star = new DropItem(Items.field_151156_bN, 1, 1, new Conditional[0]);
        this.registerMob(new MobEntry((EntityLivingBase)new EntityWither(world), LightLevel.any, star));
        DropItem egg = new DropItem(new ItemStack(Blocks.field_150380_bt), 1, 1, new Conditional[0]);
        this.registerMob(new MobEntry((EntityLivingBase)new EntityDragon(world), LightLevel.any, egg));
        DropItem pearl = new DropItem(Items.field_151079_bi, 0, 1, new Conditional[0]);
        this.registerMob(new MobEntry((EntityLivingBase)new EntityEnderman(world), LightLevel.hostile, pearl));
        DropItem rottenFlesh = new DropItem(Items.field_151078_bh, 0, 2, new Conditional[0]);
        ironIngot = new DropItem(Items.field_151042_j, 1, 1, 0.008f, Conditional.playerKill, Conditional.rareDrop);
        DropItem potato = new DropItem(Items.field_151174_bG, 1, 1, 0.008f, Conditional.playerKill, Conditional.rareDrop);
        DropItem carrot = new DropItem(Items.field_151172_bF, 1, 1, 0.008f, Conditional.playerKill, Conditional.rareDrop);
        this.registerMob(new MobEntry((EntityLivingBase)new EntityZombie(world), LightLevel.hostile, rottenFlesh, ironIngot, potato, carrot));
        DropItem goldNugget = new DropItem(Items.field_151074_bl, 0, 1, new Conditional[0]);
        DropItem goldIngot = new DropItem(Items.field_151043_k, 0, 1, 0.025f, Conditional.playerKill, Conditional.rareDrop);
        this.registerMob(new MobEntry((EntityLivingBase)new EntityPigZombie(world), LightLevel.any, new String[]{"Nether"}, rottenFlesh, goldNugget, goldIngot));
        DropItem bone = new DropItem(Items.field_151103_aS, 0, 2, new Conditional[0]);
        DropItem arrow = new DropItem(Items.field_151032_g, 0, 2, new Conditional[0]);
        this.registerMob(new MobEntry((EntityLivingBase)new EntitySkeleton(world), LightLevel.hostile, bone, arrow));
        DropItem coal = new DropItem(Items.field_151044_h, 0, 1, 0.33f, new Conditional[0]);
        DropItem skull = new DropItem(new ItemStack(Items.field_151144_bL, 1, 1), 1, 1, 0.025f, Conditional.playerKill, Conditional.rareDrop);
        EntitySkeleton witherSkeleton = new EntitySkeleton(world);
        witherSkeleton.func_82201_a(1);
        this.registerMob(new MobEntry((EntityLivingBase)witherSkeleton, LightLevel.hostile, new String[]{"Nether Fortress"}, bone, coal, skull));
        DropItem gunpowder = new DropItem(Items.field_151016_H, 0, 2, new Conditional[0]);
        this.registerMob(new MobEntry((EntityLivingBase)new EntityCreeper(world), LightLevel.hostile, gunpowder));
        DropItem tear = new DropItem(Items.field_151073_bk, 0, 1, new Conditional[0]);
        this.registerMob(new MobEntry((EntityLivingBase)new EntityGhast(world), LightLevel.hostile, new String[]{"Nether"}, gunpowder, tear));
        DropItem bottle = new DropItem(Items.field_151069_bo, 0, 6, new Conditional[0]);
        DropItem glowstone = new DropItem(Items.field_151114_aO, 0, 6, new Conditional[0]);
        gunpowder = new DropItem(Items.field_151016_H, 0, 6, new Conditional[0]);
        DropItem redstone = new DropItem(Items.field_151137_ax, 0, 6, new Conditional[0]);
        DropItem spider = new DropItem(Items.field_151070_bp, 0, 6, new Conditional[0]);
        DropItem stick = new DropItem(Items.field_151055_y, 0, 6, new Conditional[0]);
        DropItem sugar = new DropItem(Items.field_151102_aT, 0, 6, new Conditional[0]);
        this.registerMob(new MobEntry((EntityLivingBase)new EntityWitch(world), LightLevel.hostile, bottle, glowstone, gunpowder, redstone, spider, stick, sugar));
        DropItem slimeball = new DropItem(Items.field_151123_aH, 0, 2, Conditional.slimeBall);
        this.registerMob(new MobEntry((EntityLivingBase)MonsterHelper.setSlimeSize(new EntitySlime(world), 1), LightLevel.hostile, slimeball));
        DropItem magma = new DropItem(Items.field_151064_bs, 0, 1, Conditional.magmaCream);
        this.registerMob(new MobEntry((EntityLivingBase)MonsterHelper.setSlimeSize((EntitySlime)new EntityMagmaCube(world), 1), LightLevel.hostile, new String[]{"Nether"}, magma));
        DropItem blazeRod = new DropItem(Items.field_151072_bj, 0, 1, Conditional.playerKill);
        this.registerMob(new MobEntry((EntityLivingBase)new EntityBlaze(world), LightLevel.blaze, new String[]{"Nether Fortress"}, blazeRod));
        this.registerMob(new MobEntry((EntityLivingBase)new EntitySilverfish(world), LightLevel.hostile, new DropItem[0]));
        this.registerMob(new MobEntry((EntityLivingBase)new EntityBat(world), LightLevel.hostile, new DropItem[0]));
        DropItem string = new DropItem(Items.field_151007_F, 0, 2, new Conditional[0]);
        spider = new DropItem(Items.field_151070_bp, 1, 1, 0.33f, Conditional.playerKill);
        this.registerMob(new MobEntry((EntityLivingBase)new EntitySpider(world), LightLevel.hostile, string, spider));
        this.registerMob(new MobEntry((EntityLivingBase)new EntityCaveSpider(world), LightLevel.hostile, string, spider));
        DropItem ink = new DropItem(Items.field_151100_aR, 0, 1, 3, new Conditional[0]);
        this.registerMob(new MobEntry((EntityLivingBase)new EntitySquid(world), LightLevel.any, new String[]{"In water"}, ink));
    }

    private void registerDungeonLoot() {
        HashMap dungeons = (HashMap)ReflectionHelper.getObject(ChestGenHooks.class, "chestInfo", null);
        ChestGenHooks bonusChest = ChestGenHooks.getInfo((String)"bonusChest");
        for (ChestGenHooks chestGenHook : dungeons.values()) {
            if (chestGenHook == bonusChest) continue;
            DungeonRegistry.getInstance().registerChestHook(chestGenHook);
        }
    }

    private void registerOres() {
        this.registerOre(new RegisterOreMessage(new ItemStack(Blocks.field_150369_x), (DistributionBase)new DistributionTriangular(15, 15, 0.001f), new ItemStack[0]));
        this.registerOre(new RegisterOreMessage(new ItemStack(Blocks.field_150366_p), (DistributionBase)new DistributionSquare(0, 5, 54, 65, 0.006f), new ItemStack[0]));
        this.registerOre(new RegisterOreMessage(new ItemStack(Blocks.field_150450_ax), (DistributionBase)new DistributionSquare(0, 5, 12, 17, 0.0083f), new ItemStack[0]));
        this.registerOre(new RegisterOreMessage(new ItemStack(Blocks.field_150482_ag), (DistributionBase)new DistributionSquare(0, 5, 12, 17, 0.0012f), new ItemStack[0]));
        this.registerOre(new RegisterOreMessage(new ItemStack(Blocks.field_150412_bA), (DistributionBase)new DistributionSquare(0, 5, 12, 17, 0.0012f), new ItemStack[0]));
        this.registerOre(new RegisterOreMessage(new ItemStack(Blocks.field_150352_o), (DistributionBase)new DistributionSquare(0, 5, 29, 35, 0.0012f), new ItemStack[0]));
        this.registerOre(new RegisterOreMessage(new ItemStack(Blocks.field_150365_q), (DistributionBase)new DistributionSquare(0, 5, 54, 76, 0.01f), new ItemStack[0]));
    }

    private void registerVanillaPlants() {
        ItemStack potatoPlant = new ItemStack(Blocks.field_150469_bN);
        PlantDrop potato = new PlantDrop(new ItemStack(Items.field_151174_bG), 1, 4);
        PlantDrop poisonous = new PlantDrop(new ItemStack(Items.field_151170_bI), 0.02f);
        this.registerPlant(new PlantEntry(potatoPlant, potato, poisonous));
        ItemStack carrotPlant = new ItemStack(Blocks.field_150459_bM);
        PlantDrop carrot = new PlantDrop(new ItemStack(Items.field_151172_bF), 1, 4);
        this.registerPlant(new PlantEntry(carrotPlant, carrot));
    }
}

