/*
 * Decompiled with CFR 0.152.
 */
package neresources.utils;

import cpw.mods.fml.common.Loader;
import neresources.compatibility.CompatBase;
import neresources.compatibility.appliedenergistics2.AE2Compat;
import neresources.compatibility.bigreactors.BigReactorsCompat;
import neresources.compatibility.cofh.CoFHCompat;
import neresources.compatibility.forestry.ForestryCompat;
import neresources.compatibility.ic2.IC2Compat;
import neresources.compatibility.metallurgy.MetallurgyCompat;
import neresources.compatibility.minecraft.MinecraftCompat;
import neresources.compatibility.mobproperties.MobPropertiesCompat;
import neresources.compatibility.netherores.NetherOresCompat;
import neresources.compatibility.reika.ElectriCraftCompat;
import neresources.compatibility.reika.ReactorCraftCompat;
import neresources.compatibility.thaumcraft.ThaumcraftCompat;
import neresources.compatibility.tinkersconstruct.TiConCompat;

public enum ModList {
    minecraft(new MinecraftCompat()),
    cofhcore("CoFHCore", new CoFHCompat()),
    metallurgy("Metallurgy", new MetallurgyCompat()),
    netherores("NetherOres", new NetherOresCompat()),
    bigreactors("BigReactors", new BigReactorsCompat()),
    ae2("appliedenergistics2", new AE2Compat()),
    thaumcraft("Thaumcraft", new ThaumcraftCompat()),
    electricraft("ElectriCraft", new ElectriCraftCompat()),
    reactorcraft("ReactorCraft", new ReactorCraftCompat()),
    forestry("Forestry", new ForestryCompat()),
    ticon("TConstruct", new TiConCompat()),
    denseores("denseores"),
    mystcraft("Mystcraft"),
    ic2("IC2", new IC2Compat()),
    mobproperties("MobProperties", new MobPropertiesCompat());

    private String name;
    private CompatBase compat;
    private boolean isLoaded;

    private ModList(CompatBase compat) {
        this.name = "minecraft";
        this.compat = compat;
        this.isLoaded = true;
    }

    private ModList(String name) {
        this(name, null);
    }

    private ModList(String name, CompatBase compat) {
        this.name = name;
        this.compat = compat;
        this.isLoaded = Loader.isModLoaded((String)this.name);
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public String toString() {
        return this.name;
    }

    public boolean initialise() {
        if (this.compat == null) {
            return false;
        }
        return this.compat.load(this);
    }

    public class Names {
        public static final String COFHCORE = "CoFHCore";
        public static final String METALLURGY = "Metallurgy";
        public static final String APPLIEDENERGISTICS = "appliedenergistics2";
        public static final String BIGREACTORS = "BigReactors";
        public static final String FORESTRY = "Forestry";
        public static final String NETHERORES = "NetherOres";
        public static final String ELECTRICRAFT = "ElectriCraft";
        public static final String REACTORCRAFT = "ReactorCraft";
        public static final String THAUMCRAFT = "Thaumcraft";
        public static final String TICON = "TConstruct";
        public static final String DENSEORES = "denseores";
        public static final String MYSTCRAFT = "Mystcraft";
        public static final String IC2 = "IC2";
        public static final String MOBPROPERTIES = "MobProperties";
    }
}

