/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.soundfilters;

import com.tmtravlr.soundfilters.SoundFiltersMod;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import paulscode.sound.Source;

public class SoundTickHandler {
    private Minecraft mc = Minecraft.func_71410_x();
    private static int profileTickCountdown = 13;
    private static float prevDecayFactor = 0.0f;
    private static float prevRoomFactor = 0.0f;
    private static float prevSkyFactor = 0.0f;
    public static float baseLowPassGain = 1.0f;
    public static float baseLowPassGainHF = 1.0f;
    public static boolean waterSound = false;
    public static boolean lavaSound = false;
    public static Comparator<ComparablePosition> CPcomparator = new Comparator<ComparablePosition>(){

        @Override
        public int compare(ComparablePosition first, ComparablePosition second) {
            return first.compareTo(second);
        }
    };
    public static ConcurrentSkipListMap<ComparablePosition, DoubleWithTimeout> sourceOcclusionMap = new ConcurrentSkipListMap(CPcomparator);

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (this.mc != null && this.mc.field_71441_e != null && this.mc.field_71439_g != null) {
                if (this.mc.field_71439_g.func_70055_a(Material.field_151586_h)) {
                    if (!waterSound) {
                        if (SoundFiltersMod.DEBUG) {
                            System.out.println("[SoundFilters] Applying water sound low pass.");
                        }
                        baseLowPassGain = 1.0f;
                        baseLowPassGainHF = 0.4f;
                        lavaSound = false;
                        waterSound = true;
                    }
                } else if (waterSound) {
                    if (SoundFiltersMod.DEBUG) {
                        System.out.println("[SoundFilters] Stopping water sound low pass.");
                    }
                    baseLowPassGain = 1.0f;
                    baseLowPassGainHF = 1.0f;
                    waterSound = false;
                }
                if (this.mc.field_71439_g.func_70055_a(Material.field_151587_i)) {
                    if (!lavaSound) {
                        if (SoundFiltersMod.DEBUG) {
                            System.out.println("[SoundFilters] Applying lava sound low pass.");
                        }
                        baseLowPassGain = 0.6f;
                        baseLowPassGainHF = 0.2f;
                        lavaSound = true;
                        waterSound = false;
                    }
                } else if (lavaSound) {
                    if (SoundFiltersMod.DEBUG) {
                        System.out.println("[SoundFilters] Stopping lava sound low pass.");
                    }
                    baseLowPassGain = 1.0f;
                    baseLowPassGainHF = 1.0f;
                    lavaSound = false;
                }
            } else {
                baseLowPassGain = 1.0f;
                baseLowPassGainHF = 1.0f;
                SoundFiltersMod.reverbFilter.decayTime = 0.1f;
                SoundFiltersMod.reverbFilter.reflectionsDelay = 0.0f;
                SoundFiltersMod.reverbFilter.lateReverbDelay = 0.0f;
                lavaSound = false;
                waterSound = false;
            }
        } else {
            ArrayList<ComparablePosition> toRemove = new ArrayList<ComparablePosition>();
            if (SoundFiltersMod.doOcclusion) {
                for (ComparablePosition sourcePosition : sourceOcclusionMap.keySet()) {
                    DoubleWithTimeout sourceAndAmount = sourceOcclusionMap.get(sourcePosition);
                    if (sourceAndAmount == null) continue;
                    if (sourceAndAmount.source != null && sourceAndAmount.source.position != null && sourceAndAmount.source.playing() && !sourceAndAmount.source.stopped() && sourceAndAmount.timeout > 0) {
                        --sourceAndAmount.timeout;
                        if (this.mc != null && this.mc.field_71441_e != null && this.mc.field_71439_g != null) {
                            Vec3 roomSize = Vec3.func_72443_a((double)this.mc.field_71439_g.field_70165_t, (double)(this.mc.field_71439_g.field_70163_u + (double)this.mc.field_71439_g.func_70047_e()), (double)this.mc.field_71439_g.field_70161_v);
                            sourceAndAmount.amount = (sourceAndAmount.amount * 3.0 + SoundTickHandler.getSoundOcclusion((World)this.mc.field_71441_e, Vec3.func_72443_a((double)sourceAndAmount.source.position.x, (double)sourceAndAmount.source.position.y, (double)sourceAndAmount.source.position.z), roomSize)) / 4.0;
                            continue;
                        }
                        sourceAndAmount.amount = 0.0;
                        continue;
                    }
                    if (sourceAndAmount.timeout <= 0) {
                        toRemove.add(sourcePosition);
                    }
                    --sourceAndAmount.timeout;
                }
                for (ComparablePosition positionToRemove : toRemove) {
                    if (SoundFiltersMod.SUPER_DUPER_DEBUG) {
                        System.out.println("[Sound Filters] Removing " + positionToRemove + ", " + positionToRemove.hashCode() + ", " + profileTickCountdown);
                    }
                    sourceOcclusionMap.remove(positionToRemove);
                }
            }
            if (this.mc != null && this.mc.field_71441_e != null && this.mc.field_71439_g != null && SoundFiltersMod.doReverb && --profileTickCountdown <= 0) {
                int i;
                profileTickCountdown = 13;
                Random rand = new Random();
                TreeSet<ComparablePosition> visited = new TreeSet<ComparablePosition>(CPcomparator);
                ArrayList<SoundFiltersMod.BlockMeta> blocksFound = new ArrayList<SoundFiltersMod.BlockMeta>();
                LinkedList<ComparablePosition> toVisit = new LinkedList<ComparablePosition>();
                toVisit.add(new ComparablePosition(MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70165_t), MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70163_u), MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70161_v)));
                for (i = 0; i < SoundFiltersMod.profileSize && !toVisit.isEmpty(); ++i) {
                    ComparablePosition current = (ComparablePosition)toVisit.remove(rand.nextInt(toVisit.size()));
                    visited.add(current);
                    ComparablePosition pos = new ComparablePosition(current.x, current.y, current.z + 1.0f);
                    Block block = this.mc.field_71441_e.func_147439_a(pos.x(), pos.y(), pos.z());
                    Material material = block.func_149688_o();
                    if (!material.func_76230_c()) {
                        if (!visited.contains(pos) && !toVisit.contains(pos)) {
                            toVisit.add(pos);
                        }
                        if (material != Material.field_151579_a) {
                            blocksFound.add(new SoundFiltersMod.BlockMeta(block, this.mc.field_71441_e.func_72805_g(pos.x(), pos.y(), pos.z())));
                        }
                    } else {
                        blocksFound.add(new SoundFiltersMod.BlockMeta(block, this.mc.field_71441_e.func_72805_g(pos.x(), pos.y(), pos.z())));
                    }
                    if (!(material = (block = this.mc.field_71441_e.func_147439_a((pos = new ComparablePosition(current.x, current.y, current.z - 1.0f)).x(), pos.y(), pos.z())).func_149688_o()).func_76230_c()) {
                        if (!visited.contains(pos) && !toVisit.contains(pos)) {
                            toVisit.add(pos);
                        }
                        if (material != Material.field_151579_a) {
                            blocksFound.add(new SoundFiltersMod.BlockMeta(block, this.mc.field_71441_e.func_72805_g(pos.x(), pos.y(), pos.z())));
                        }
                    } else {
                        blocksFound.add(new SoundFiltersMod.BlockMeta(block, this.mc.field_71441_e.func_72805_g(pos.x(), pos.y(), pos.z())));
                    }
                    if (!(material = (block = this.mc.field_71441_e.func_147439_a((pos = new ComparablePosition(current.x, current.y + 1.0f, current.z)).x(), pos.y(), pos.z())).func_149688_o()).func_76230_c()) {
                        if (!visited.contains(pos) && !toVisit.contains(pos)) {
                            toVisit.add(pos);
                        }
                        if (material != Material.field_151579_a) {
                            blocksFound.add(new SoundFiltersMod.BlockMeta(block, this.mc.field_71441_e.func_72805_g(pos.x(), pos.y(), pos.z())));
                        }
                    } else {
                        blocksFound.add(new SoundFiltersMod.BlockMeta(block, this.mc.field_71441_e.func_72805_g(pos.x(), pos.y(), pos.z())));
                    }
                    if (!(material = (block = this.mc.field_71441_e.func_147439_a((pos = new ComparablePosition(current.x, current.y - 1.0f, current.z)).x(), pos.y(), pos.z())).func_149688_o()).func_76230_c()) {
                        if (!visited.contains(pos) && !toVisit.contains(pos)) {
                            toVisit.add(pos);
                        }
                        if (material != Material.field_151579_a) {
                            blocksFound.add(new SoundFiltersMod.BlockMeta(block, this.mc.field_71441_e.func_72805_g(pos.x(), pos.y(), pos.z())));
                        }
                    } else {
                        blocksFound.add(new SoundFiltersMod.BlockMeta(block, this.mc.field_71441_e.func_72805_g(pos.x(), pos.y(), pos.z())));
                    }
                    if (!(material = (block = this.mc.field_71441_e.func_147439_a((pos = new ComparablePosition(current.x + 1.0f, current.y, current.z)).x(), pos.y(), pos.z())).func_149688_o()).func_76230_c()) {
                        if (!visited.contains(pos) && !toVisit.contains(pos)) {
                            toVisit.add(pos);
                        }
                        if (material != Material.field_151579_a) {
                            blocksFound.add(new SoundFiltersMod.BlockMeta(block, this.mc.field_71441_e.func_72805_g(pos.x(), pos.y(), pos.z())));
                        }
                    } else {
                        blocksFound.add(new SoundFiltersMod.BlockMeta(block, this.mc.field_71441_e.func_72805_g(pos.x(), pos.y(), pos.z())));
                    }
                    if (!(material = (block = this.mc.field_71441_e.func_147439_a((pos = new ComparablePosition(current.x - 1.0f, current.y, current.z)).x(), pos.y(), pos.z())).func_149688_o()).func_76230_c()) {
                        if (!visited.contains(pos) && !toVisit.contains(pos)) {
                            toVisit.add(pos);
                        }
                        if (material == Material.field_151579_a) continue;
                        blocksFound.add(new SoundFiltersMod.BlockMeta(block, this.mc.field_71441_e.func_72805_g(pos.x(), pos.y(), pos.z())));
                        continue;
                    }
                    blocksFound.add(new SoundFiltersMod.BlockMeta(block, this.mc.field_71441_e.func_72805_g(pos.x(), pos.y(), pos.z())));
                }
                int roomSize = visited.size();
                double highReverb = 0.0;
                double midReverb = 0.0;
                double lowReverb = 0.0;
                for (SoundFiltersMod.BlockMeta blockMeta : blocksFound) {
                    Block b = blockMeta.block;
                    SoundFiltersMod.BlockMeta blockInfo = new SoundFiltersMod.BlockMeta(blockMeta.block, 16);
                    if (!SoundFiltersMod.customReverb.containsKey(blockInfo)) {
                        blockInfo = new SoundFiltersMod.BlockMeta(blockMeta.block, blockMeta.meta);
                    }
                    if (SoundFiltersMod.customReverb.containsKey(blockInfo)) {
                        double factor = SoundFiltersMod.customReverb.get(blockInfo);
                        lowReverb += factor >= 1.0 || factor < 0.0 ? 0.0 : 1.0 - factor;
                        midReverb += factor >= 2.0 || factor <= 0.0 ? 0.0 : 1.0 - Math.abs(factor - 1.0);
                        highReverb += factor <= 1.0 ? 0.0 : (factor > 2.0 ? 1.0 : factor - 1.0);
                        continue;
                    }
                    if (b.func_149688_o() != Material.field_151576_e && b.func_149688_o() != Material.field_151592_s && b.func_149688_o() != Material.field_151588_w && b.func_149688_o() != Material.field_151573_f) {
                        if (b.func_149688_o() != Material.field_151570_A && b.func_149688_o() != Material.field_151568_F && b.func_149688_o() != Material.field_151580_n && b.func_149688_o() != Material.field_151589_v && b.func_149688_o() != Material.field_151577_b && b.func_149688_o() != Material.field_151584_j && b.func_149688_o() != Material.field_151593_r && b.func_149688_o() != Material.field_151585_k && b.func_149688_o() != Material.field_151572_C && b.func_149688_o() != Material.field_151597_y && b.func_149688_o() != Material.field_151583_m && b.func_149688_o() != Material.field_151582_l && b.func_149688_o() != Material.field_151569_G) {
                            midReverb += 1.0;
                            continue;
                        }
                        lowReverb += 1.0;
                        continue;
                    }
                    highReverb += 1.0;
                }
                float skyFactor = 0.0f;
                if (SoundFiltersMod.doSkyChecks && roomSize == SoundFiltersMod.profileSize) {
                    int z;
                    int y;
                    int x = MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70165_t);
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x, y = MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70163_u), z = MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70161_v))) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x + rand.nextInt(5) + 5, y, z)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x - rand.nextInt(5) + 5, y, z)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x, y, z + rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x, y, z - rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x + rand.nextInt(5) + 5, y, z + rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x - rand.nextInt(5) + 5, y, z + rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x + rand.nextInt(5) + 5, y, z - rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x - rand.nextInt(5) + 5, y, z - rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x + rand.nextInt(5) + 5, y + 5, z)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x - rand.nextInt(5) + 5, y + 5, z)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x, y + 5, z + rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x, y + 5, z - rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x + rand.nextInt(5) + 5, y + 5, z + rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x - rand.nextInt(5) + 5, y + 5, z + rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x + rand.nextInt(5) + 5, y + 5, z - rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                    if (SoundTickHandler.onlySkyAboveBlock((World)this.mc.field_71441_e, x - rand.nextInt(5) + 5, y + 5, z - rand.nextInt(5) + 5)) {
                        skyFactor += 1.0f;
                    }
                }
                skyFactor = 1.0f - skyFactor / 17.0f;
                float decayFactor = 0.0f;
                float roomFactor = (float)roomSize / (float)SoundFiltersMod.profileSize;
                if (highReverb + midReverb + lowReverb > 0.0) {
                    decayFactor += (float)(highReverb - lowReverb) / (float)(highReverb + midReverb + lowReverb);
                }
                if (decayFactor < 0.0f) {
                    decayFactor = 0.0f;
                }
                if (decayFactor > 1.0f) {
                    decayFactor = 1.0f;
                }
                if (SoundFiltersMod.SUPER_DUPER_DEBUG) {
                    System.out.println("[Sound Filters] Reverb Profile - Room Size: " + roomSize + ", Looked at: " + i + ", Sky Factor: " + skyFactor + ", High, Mid, and Low Reverb: (" + highReverb + ", " + midReverb + ", " + lowReverb + ")");
                }
                decayFactor = (decayFactor + prevDecayFactor) / 2.0f;
                roomFactor = (roomFactor + prevRoomFactor) / 2.0f;
                skyFactor = (skyFactor + prevSkyFactor) / 2.0f;
                prevDecayFactor = decayFactor;
                prevRoomFactor = roomFactor;
                SoundFiltersMod.reverbFilter.decayTime = 4.0f * decayFactor * roomFactor * skyFactor;
                if (SoundFiltersMod.reverbFilter.decayTime < 0.1f) {
                    SoundFiltersMod.reverbFilter.decayTime = 0.1f;
                }
                SoundFiltersMod.reverbFilter.reflectionsDelay = 0.025f * roomFactor;
                SoundFiltersMod.reverbFilter.lateReverbDelay = 0.01f * roomFactor;
            }
        }
    }

    private static boolean onlySkyAboveBlock(World world, int x, int y, int z) {
        for (int i = y; i < 256; ++i) {
            Block block = world.func_147439_a(x, i, z);
            if (!block.func_149688_o().func_76230_c()) continue;
            return false;
        }
        return true;
    }

    public static double getSoundOcclusion(World world, Vec3 sound, Vec3 listener) {
        double occludedPercent = 0.0;
        sound.field_72450_a += 0.1;
        sound.field_72448_b += 0.1;
        sound.field_72449_c += 0.1;
        if (!(Double.isNaN(sound.field_72450_a) || Double.isNaN(sound.field_72448_b) || Double.isNaN(sound.field_72449_c))) {
            if (!(Double.isNaN(listener.field_72450_a) || Double.isNaN(listener.field_72448_b) || Double.isNaN(listener.field_72449_c))) {
                int listenerX = MathHelper.func_76128_c((double)listener.field_72450_a);
                int listenerY = MathHelper.func_76128_c((double)listener.field_72448_b);
                int listenerZ = MathHelper.func_76128_c((double)listener.field_72449_c);
                int soundX = MathHelper.func_76128_c((double)sound.field_72450_a);
                int soundY = MathHelper.func_76128_c((double)sound.field_72448_b);
                int soundZ = MathHelper.func_76128_c((double)sound.field_72449_c);
                int countDown = 200;
                while (countDown-- >= 0) {
                    MovingObjectPosition mop;
                    int whichToChange;
                    if (Double.isNaN(sound.field_72450_a) || Double.isNaN(sound.field_72448_b) || Double.isNaN(sound.field_72449_c)) {
                        return occludedPercent;
                    }
                    if (soundX == listenerX && soundY == listenerY && soundZ == listenerZ) {
                        return occludedPercent;
                    }
                    boolean shouldChangeX = true;
                    boolean shouldChangeY = true;
                    boolean shouldChangeZ = true;
                    double newX = 999.0;
                    double newY = 999.0;
                    double newZ = 999.0;
                    if (listenerX == soundX) {
                        shouldChangeX = false;
                    }
                    if (shouldChangeX) {
                        newX = (double)soundX + (listenerX > soundX ? 1.0 : 0.0);
                    }
                    if (listenerY == soundY) {
                        shouldChangeY = false;
                    }
                    if (shouldChangeY) {
                        newY = (double)soundY + (listenerY > soundY ? 1.0 : 0.0);
                    }
                    if (listenerZ == soundZ) {
                        shouldChangeZ = false;
                    }
                    if (shouldChangeZ) {
                        newZ = (double)soundZ + (listenerZ > soundZ ? 1.0 : 0.0);
                    }
                    double xPercentChange = 999.0;
                    double yPercentChange = 999.0;
                    double zPercentChange = 999.0;
                    double xDifference = listener.field_72450_a - sound.field_72450_a;
                    double yDifference = listener.field_72448_b - sound.field_72448_b;
                    double zDifference = listener.field_72449_c - sound.field_72449_c;
                    if (shouldChangeX) {
                        xPercentChange = (newX - sound.field_72450_a) / xDifference;
                    }
                    if (shouldChangeY) {
                        yPercentChange = (newY - sound.field_72448_b) / yDifference;
                    }
                    if (shouldChangeZ) {
                        zPercentChange = (newZ - sound.field_72449_c) / zDifference;
                    }
                    if (xPercentChange < yPercentChange && xPercentChange < zPercentChange) {
                        whichToChange = listenerX > soundX ? 4 : 5;
                        sound.field_72450_a = newX;
                        sound.field_72448_b += yDifference * xPercentChange;
                        sound.field_72449_c += zDifference * xPercentChange;
                    } else if (yPercentChange < zPercentChange) {
                        whichToChange = listenerY > soundY ? 0 : 1;
                        sound.field_72450_a += xDifference * yPercentChange;
                        sound.field_72448_b = newY;
                        sound.field_72449_c += zDifference * yPercentChange;
                    } else {
                        whichToChange = listenerZ > soundZ ? 2 : 3;
                        sound.field_72450_a += xDifference * zPercentChange;
                        sound.field_72448_b += yDifference * zPercentChange;
                        sound.field_72449_c = newZ;
                    }
                    Vec3 vec32 = Vec3.func_72443_a((double)sound.field_72450_a, (double)sound.field_72448_b, (double)sound.field_72449_c);
                    vec32.field_72450_a = MathHelper.func_76128_c((double)sound.field_72450_a);
                    soundX = (int)vec32.field_72450_a;
                    if (whichToChange == 5) {
                        --soundX;
                        vec32.field_72450_a += 1.0;
                    }
                    vec32.field_72448_b = MathHelper.func_76128_c((double)sound.field_72448_b);
                    soundY = (int)vec32.field_72448_b;
                    if (whichToChange == 1) {
                        --soundY;
                        vec32.field_72448_b += 1.0;
                    }
                    vec32.field_72449_c = MathHelper.func_76128_c((double)sound.field_72449_c);
                    soundZ = (int)vec32.field_72449_c;
                    if (whichToChange == 3) {
                        --soundZ;
                        vec32.field_72449_c += 1.0;
                    }
                    Block block = world.func_147439_a(soundX, soundY, soundZ);
                    int meta = world.func_72805_g(soundX, soundY, soundZ);
                    Material material = block.func_149688_o();
                    if (block == null || block == Blocks.field_150350_a || block.func_149668_a(world, soundX, soundY, soundZ) == null || !block.func_149678_a(meta, false) || (mop = block.func_149731_a(world, soundX, soundY, soundZ, sound, listener)) == null) continue;
                    SoundFiltersMod.BlockMeta blockInfo = new SoundFiltersMod.BlockMeta(block, 16);
                    if (!SoundFiltersMod.customOcclusion.containsKey(blockInfo)) {
                        blockInfo = new SoundFiltersMod.BlockMeta(block, meta);
                    }
                    if (SoundFiltersMod.customOcclusion.containsKey(blockInfo)) {
                        occludedPercent += SoundFiltersMod.customOcclusion.get(blockInfo) * 0.1;
                    } else if (occludedPercent < 0.7) {
                        occludedPercent += material.func_76218_k() ? 0.1 : 0.05;
                    }
                    if (!(occludedPercent > 0.98)) continue;
                    return 0.98;
                }
                return occludedPercent;
            }
            return occludedPercent;
        }
        return occludedPercent;
    }

    public static class DoubleWithTimeout {
        public Source source;
        public double amount;
        public int timeout;

        DoubleWithTimeout() {
            this(null, 0.0, 10);
        }

        DoubleWithTimeout(Source sToSet, double dToSet, int iToSet) {
            this.source = sToSet;
            this.amount = dToSet;
            this.timeout = iToSet;
        }
    }

    public static class ComparablePosition
    implements Comparable {
        float x;
        float y;
        float z;

        ComparablePosition(float xToSet, float yToSet, float zToSet) {
            this.x = xToSet;
            this.y = yToSet;
            this.z = zToSet;
        }

        public int x() {
            return MathHelper.func_76128_c((double)this.x);
        }

        public int y() {
            return MathHelper.func_76128_c((double)this.y);
        }

        public int z() {
            return MathHelper.func_76128_c((double)this.z);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ComparablePosition)) {
                return false;
            }
            ComparablePosition toCompare = (ComparablePosition)object;
            return toCompare.compareTo(this) == 0;
        }

        public int compareTo(Object object) {
            if (!(object instanceof ComparablePosition)) {
                return 0;
            }
            ComparablePosition toCompare = (ComparablePosition)object;
            if ((double)(toCompare.x - this.x) > 0.1) {
                return 1;
            }
            if ((double)(toCompare.x - this.x) < -0.1) {
                return -1;
            }
            if ((double)(toCompare.y - this.y) > 0.1) {
                return 1;
            }
            if ((double)(toCompare.y - this.y) < -0.1) {
                return -1;
            }
            if ((double)(toCompare.z - this.z) > 0.1) {
                return 1;
            }
            if ((double)(toCompare.z - this.z) < -0.1) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "[" + this.x + ", " + this.y + ", " + this.z + "]";
        }
    }
}

