/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;
import com.enderio.core.common.vecmath.Vertex;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import crazypants.enderio.machine.obelisk.BlockObeliskAbstract;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class ObeliskRenderer
implements ISimpleBlockRenderingHandler {
    private VertXForm2 xform2 = new VertXForm2();
    private VertXForm3 xform3 = new VertXForm3();
    private static float WIDE_PINCH = 0.9f;
    private static float WIDTH = 0.5625f * WIDE_PINCH;

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        GL11.glDisable((int)2896);
        Tessellator.field_78398_a.func_78382_b();
        this.renderWorldBlock(null, 0, 0, 0, block, 0, renderer);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glEnable((int)2896);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        IIcon[] icons;
        IIcon icon;
        Tessellator.field_78398_a.func_78372_c((float)x, (float)y, (float)z);
        IIcon[] bottomIcon = null;
        if (world != null) {
            RenderUtil.setTesselatorBrightness((IBlockAccess)world, (int)x, (int)y, (int)z);
            icon = block.func_149673_e(world, x, y, z, 0);
            icons = RenderUtil.getBlockTextures((IBlockAccess)world, (int)x, (int)y, (int)z);
        } else {
            icon = block.func_149691_a(1, 0);
            icons = RenderUtil.getBlockTextures((Block)block, (int)0);
        }
        if (icons != null) {
            bottomIcon = new IIcon[6];
            for (int i = 0; i < bottomIcon.length; ++i) {
                bottomIcon[i] = IconUtil.blankTexture;
            }
            bottomIcon[0] = icons[0];
            icons[0] = IconUtil.blankTexture;
        }
        if (renderer.func_147744_b()) {
            icon = renderer.field_147840_d;
            icons = null;
        }
        float height = 0.475f;
        float width = WIDTH;
        BoundingBox bb = BoundingBox.UNIT_CUBE.scale(width, height, 1.0f).translate(0.0f, -0.5f + height / 2.0f, 0.0f);
        this.xform2.isX = false;
        if (icons == null) {
            CubeRenderer.render((BoundingBox)bb, (IIcon)icon, (VertexTransform)this.xform2, (boolean)true);
        } else {
            CubeRenderer.render((BoundingBox)bb, (IIcon[])icons, (VertexTransform)this.xform2, (boolean)true);
        }
        bb = BoundingBox.UNIT_CUBE.scale(1.0f, height, width).translate(0.0f, -0.5f + height / 2.0f, 0.0f);
        this.xform2.isX = true;
        if (icons == null) {
            CubeRenderer.render((BoundingBox)bb, (IIcon)icon, (VertexTransform)this.xform2, (boolean)true);
        } else {
            CubeRenderer.render((BoundingBox)bb, (IIcon[])icons, (VertexTransform)this.xform2, (boolean)true);
        }
        if (bottomIcon != null) {
            bb = BoundingBox.UNIT_CUBE;
            CubeRenderer.render((BoundingBox)bb, (IIcon[])bottomIcon, (VertexTransform)this.xform3, (boolean)true);
        }
        Tessellator.field_78398_a.func_78372_c((float)(-x), (float)(-y), (float)(-z));
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BlockObeliskAbstract.defaultObeliskRenderId;
    }

    private static class VertXForm3
    implements VertexTransform {
        public void apply(Vertex vertex) {
            this.apply(vertex.xyz);
        }

        public void apply(Vector3d vec) {
            vec.x -= 0.5;
            vec.x *= (double)WIDE_PINCH;
            vec.x += 0.5;
            vec.z -= 0.5;
            vec.z *= (double)WIDE_PINCH;
            vec.z += 0.5;
        }

        public void applyToNormal(Vector3f vec) {
        }
    }

    private static class VertXForm2
    implements VertexTransform {
        boolean isX = true;

        public void apply(Vertex vertex) {
            this.apply(vertex.xyz);
        }

        public void apply(Vector3d vec) {
            double pinch = WIDE_PINCH;
            if (vec.y > 0.2) {
                pinch = 0.5;
            }
            if (this.isX) {
                vec.x -= 0.5;
                vec.x *= pinch;
                vec.x += 0.5;
            } else {
                vec.z -= 0.5;
                vec.z *= pinch;
                vec.z += 0.5;
            }
        }

        public void applyToNormal(Vector3f vec) {
        }
    }
}

