/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector3d;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.teleport.ITelePad;
import crazypants.enderio.teleport.anchor.BlockTravelAnchor;
import crazypants.enderio.teleport.telepad.TileTelePad;
import java.util.List;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C08PacketPlayerBlockPlacement;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemCoordSelector
extends Item
implements IResourceTooltipProvider {
    public static ItemCoordSelector create() {
        ItemCoordSelector ret = new ItemCoordSelector();
        GameRegistry.registerItem((Item)ret, (String)ModObject.itemCoordSelector.unlocalisedName);
        return ret;
    }

    private ItemCoordSelector() {
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77655_b(ModObject.itemCoordSelector.unlocalisedName);
        this.func_111206_d("EnderIO:" + ModObject.itemCoordSelector.unlocalisedName);
        this.func_77625_d(1);
    }

    public void func_150895_a(Item item, CreativeTabs p_150895_2_, List list) {
        ItemStack stack = new ItemStack(item);
        ItemCoordSelector.init(stack);
        list.add(stack);
    }

    public static void init(ItemStack stack) {
        stack.field_77990_d = new NBTTagCompound();
        new BlockCoord().writeToNBT(stack.field_77990_d);
        stack.field_77990_d.func_74757_a("default", true);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean p_77624_4_) {
        if (!stack.field_77990_d.func_74767_n("default")) {
            list.add(this.getCoords(stack).chatString(EnumChatFormatting.GRAY));
        }
        super.func_77624_a(stack, player, list, p_77624_4_);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (this.rayTraceCoords(stack, world, player)) {
            player.func_71038_i();
        }
        return super.func_77659_a(stack, world, player);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!this.rayTraceCoords(stack, world, player)) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ITelePad) {
            ITelePad tp = (ITelePad)te;
            TileTelePad tile = null;
            if (te instanceof TileTelePad) {
                tile = (TileTelePad)te;
            }
            if (tp.canBlockBeAccessed(player)) {
                BlockCoord bc = this.getCoords(stack);
                BlockCoord cur = new BlockCoord(tp.getX(), tp.getY(), tp.getZ());
                int dim = this.getDimension(stack);
                int curDim = tp.getTargetDim();
                if (!bc.equals((Object)cur)) {
                    if (tile != null) {
                        tile.setCoords_internal(bc);
                    } else {
                        tp.setCoords(bc);
                    }
                    if (!world.field_72995_K) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(EnderIO.lang.localize("itemCoordSelector.chat.setCoords", new Object[]{bc.chatString()})));
                    }
                }
                if (dim != curDim) {
                    if (tile != null) {
                        tile.setTargetDim_internal(dim);
                    } else {
                        tp.setTargetDim(dim);
                    }
                    if (!world.field_72995_K) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(EnderIO.lang.localize("itemCoordSelector.chat.setDimension", new Object[]{EnumChatFormatting.GREEN.toString(), Integer.toString(dim)})));
                    }
                }
                if (bc.equals((Object)cur) && dim == curDim) {
                    return false;
                }
            } else {
                BlockTravelAnchor.sendPrivateChatMessage(player, tp.getPlacedBy());
            }
        }
        if (world.field_72995_K) {
            this.sendItemUsePacket(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
        }
        return true;
    }

    private boolean rayTraceCoords(ItemStack stack, World world, EntityPlayer player) {
        Vector3d headVec = Util.getEyePositionEio((EntityPlayer)player);
        Vec3 start = headVec.getVec3();
        Vec3 lookVec = player.func_70676_i(1.0f);
        double reach = 500.0;
        headVec.add(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        MovingObjectPosition mop = world.func_72933_a(start, headVec.getVec3());
        if (mop == null) {
            return false;
        }
        BlockCoord bc = new BlockCoord(mop);
        BlockCoord onStack = this.getCoords(stack);
        TileEntity te = bc.getTileEntity((IBlockAccess)world);
        if (te instanceof ITelePad) {
            return true;
        }
        if (!player.func_70093_af()) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[mop.field_72310_e];
            bc = bc.getLocation(dir);
        }
        int dim = world.field_73011_w.field_76574_g;
        int curDim = this.getDimension(stack);
        boolean changed = false;
        if (!bc.equals((Object)onStack)) {
            this.setCoords(stack, bc);
            this.onCoordsChanged(player, bc);
            changed = true;
        }
        if (dim != curDim) {
            this.setDimension(stack, world);
            this.onDimensionChanged(player, this.getDimension(stack));
            changed = true;
        }
        return changed;
    }

    private void sendItemUsePacket(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        NetHandlerPlayClient netClientHandler = (NetHandlerPlayClient)FMLClientHandler.instance().getClientPlayHandler();
        netClientHandler.func_147297_a((Packet)new C08PacketPlayerBlockPlacement(x, y, z, side, player.field_71071_by.func_70448_g(), hitX, hitY, hitZ));
    }

    private void onCoordsChanged(EntityPlayer player, BlockCoord bc) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a((IChatComponent)new ChatComponentText(EnderIO.lang.localize("itemCoordSelector.chat.newCoords", new Object[]{bc.chatString()})));
        }
    }

    private void onDimensionChanged(EntityPlayer player, int dim) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a((IChatComponent)new ChatComponentText(EnderIO.lang.localize("itemCoordSelector.chat.newDimension", new Object[]{EnumChatFormatting.GREEN.toString(), Integer.toString(dim)})));
        }
    }

    public void setCoords(ItemStack stack, BlockCoord bc) {
        stack.field_77990_d.func_74757_a("default", false);
        bc.writeToNBT(stack.field_77990_d);
    }

    public void setDimension(ItemStack stack, World world) {
        stack.field_77990_d.func_74768_a("dimension", world.field_73011_w.field_76574_g);
    }

    public BlockCoord getCoords(ItemStack stack) {
        return BlockCoord.readFromNBT((NBTTagCompound)stack.field_77990_d);
    }

    public int getDimension(ItemStack stack) {
        return stack.field_77990_d.func_74762_e("dimension");
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.func_77658_a();
    }
}

