/*
 * Decompiled with CFR 0.152.
 */
package com.aesireanempire.eplus.network.packets;

import com.aesireanempire.eplus.EnchantingPlus;
import com.aesireanempire.eplus.inventory.ContainerEnchantTable;
import com.aesireanempire.eplus.network.packets.IPacket;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;

public class EnchantPacket
implements IPacket {
    protected int totalCost;
    protected HashMap<Integer, Integer> levels = new HashMap();
    protected HashMap<Integer, Integer> enchants = new HashMap();

    public EnchantPacket() {
    }

    public EnchantPacket(HashMap<Integer, Integer> enchants, HashMap<Integer, Integer> levels, int totalCost) {
        this.enchants = enchants;
        this.levels = levels;
        this.totalCost = totalCost;
    }

    @Override
    public void readBytes(ByteBuf bytes) {
        int i;
        HashMap<Integer, Integer> enchants = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> levels = new HashMap<Integer, Integer>();
        this.totalCost = bytes.readInt();
        int size = bytes.readInt();
        for (i = 0; i < size; ++i) {
            enchants.put(bytes.readInt(), bytes.readInt());
        }
        size = bytes.readInt();
        for (i = 0; i < size; ++i) {
            levels.put(bytes.readInt(), bytes.readInt());
        }
        this.enchants = enchants;
        this.levels = levels;
    }

    @Override
    public void writeBytes(ByteBuf bytes) {
        bytes.writeInt(this.totalCost);
        bytes.writeInt(this.enchants.size());
        for (Integer enchantmentId : this.enchants.keySet()) {
            bytes.writeInt(enchantmentId.intValue());
            bytes.writeInt(this.enchants.get(enchantmentId).intValue());
        }
        bytes.writeInt(this.levels.size());
        for (Integer enchantmentId : this.levels.keySet()) {
            bytes.writeInt(enchantmentId.intValue());
            bytes.writeInt(this.levels.get(enchantmentId).intValue());
        }
    }

    @Override
    public void executeClient(EntityPlayer player) {
    }

    @Override
    public void executeServer(EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerEnchantTable) {
            try {
                ((ContainerEnchantTable)player.field_71070_bA).enchant(player, this.enchants, this.levels, this.totalCost);
            }
            catch (Exception e) {
                EnchantingPlus.log.info("Enchanting failed because: " + e.getLocalizedMessage());
            }
            player.field_71070_bA.func_75142_b();
        }
    }
}

