/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.config;

import chanceCubes.CCubesCore;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.ConfigLoader;
import chanceCubes.registry.ChanceCubeRegistry;
import chanceCubes.rewards.defaultRewards.BasicReward;
import chanceCubes.rewards.rewardparts.ChestChanceItem;
import chanceCubes.rewards.rewardparts.CommandPart;
import chanceCubes.rewards.rewardparts.EntityPart;
import chanceCubes.rewards.rewardparts.ExpirencePart;
import chanceCubes.rewards.rewardparts.ItemPart;
import chanceCubes.rewards.rewardparts.MessagePart;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardparts.OffsetTileEntity;
import chanceCubes.rewards.rewardparts.PotionPart;
import chanceCubes.rewards.rewardparts.SoundPart;
import chanceCubes.rewards.type.BlockRewardType;
import chanceCubes.rewards.type.ChestRewardType;
import chanceCubes.rewards.type.CommandRewardType;
import chanceCubes.rewards.type.EntityRewardType;
import chanceCubes.rewards.type.ExperienceRewardType;
import chanceCubes.rewards.type.IRewardType;
import chanceCubes.rewards.type.ItemRewardType;
import chanceCubes.rewards.type.MessageRewardType;
import chanceCubes.rewards.type.PotionRewardType;
import chanceCubes.rewards.type.SoundRewardType;
import chanceCubes.util.HTTPUtil;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.logging.log4j.Level;

public class CustomRewardsLoader {
    public static CustomRewardsLoader instance;
    private File folder;
    private File source;
    private static JsonParser json;

    public CustomRewardsLoader(File folder, File source) {
        instance = this;
        this.folder = folder;
        this.source = source;
        json = new JsonParser();
        this.addCustomSounds();
    }

    public void loadCustomRewards() {
        for (File f : this.folder.listFiles()) {
            JsonElement fileJson;
            if (!f.isFile() || !f.getName().substring(f.getName().indexOf(".")).equalsIgnoreCase(".json")) continue;
            try {
                CCubesCore.logger.log(Level.INFO, "Loading custom rewards file " + f.getName());
                fileJson = json.parse((Reader)new FileReader(f));
            }
            catch (Exception e) {
                CCubesCore.logger.log(Level.ERROR, "Unable to parse the file " + f.getName() + ". Skipping file loading.");
                continue;
            }
            for (Map.Entry reward : fileJson.getAsJsonObject().entrySet()) {
                BasicReward basicReward = this.parseReward(reward);
                if (basicReward == null) continue;
                ChanceCubeRegistry.INSTANCE.registerReward(basicReward);
            }
            CCubesCore.logger.log(Level.INFO, "Loaded custom rewards file " + f.getName());
        }
    }

    public void loadHolidayRewards() {
        JsonElement holidays;
        if (!CCubesSettings.holidayRewards) {
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd");
        Date date = new Date();
        Calendar today = Calendar.getInstance();
        today.setTime(date);
        String holidayName = "";
        try {
            holidays = HTTPUtil.getWebFile(CCubesSettings.rewardURL + "/Holidays.json");
        }
        catch (Exception e1) {
            CCubesCore.logger.log(Level.ERROR, "Failed to fetch the list of holiday rewards!");
            return;
        }
        for (JsonElement holiday : holidays.getAsJsonArray()) {
            Date parsed;
            try {
                parsed = dateFormat.parse(holiday.getAsJsonObject().get("Date").getAsString().trim());
            }
            catch (ParseException e) {
                CCubesCore.logger.log(Level.ERROR, "Failed to parse a holiday date. BLAME TURKEY!!!");
                continue;
            }
            if (dateFormat.format(date).equalsIgnoreCase(dateFormat.format(parsed))) {
                holidayName = holiday.getAsJsonObject().get("Name").getAsString();
            }
            if (!holiday.getAsJsonObject().has("Texture") || holiday.getAsJsonObject().get("Texture").getAsString().equalsIgnoreCase("")) continue;
            try {
                Calendar start = Calendar.getInstance();
                Calendar end = Calendar.getInstance();
                start.setTime(dateFormat.parse(holiday.getAsJsonObject().get("Start").getAsString().trim()));
                end.setTime(dateFormat.parse(holiday.getAsJsonObject().get("End").getAsString().trim()));
                if (this.compareDates(start, today) < 0 || this.compareDates(end, today) > 0) continue;
                CCubesSettings.hasHolidayTexture = true;
                CCubesSettings.holidayTextureName = holiday.getAsJsonObject().get("Texture").getAsString();
            }
            catch (ParseException e) {
                CCubesCore.logger.log(Level.ERROR, "Failed to parse a holiday date. BLAME TURKEY!!!");
            }
        }
        if (holidayName.equalsIgnoreCase("")) {
            ConfigLoader.config.get("General Settings", "HolidayRewardTriggered", false, "Don't touch! Well I mean you can touch it, if you want. I can't stop you. I'm only text.").setValue(false);
            ConfigLoader.config.save();
            return;
        }
        if (!CCubesSettings.holidayRewardTriggered) {
            JsonElement userRewards;
            try {
                userRewards = HTTPUtil.getWebFile(CCubesSettings.rewardURL + "/HolidayRewards/" + holidayName + ".json");
            }
            catch (Exception e) {
                CCubesCore.logger.log(Level.ERROR, "Chance Cubes failed to get the custom reward for the holiday " + holidayName + "!");
                CCubesCore.logger.log(Level.ERROR, e.getMessage());
                return;
            }
            for (Map.Entry reward : userRewards.getAsJsonObject().entrySet()) {
                BasicReward basicReward = this.parseReward(reward);
                if (basicReward == null) continue;
                CCubesSettings.doesHolidayRewardTrigger = true;
                CCubesSettings.holidayReward = basicReward;
                CCubesCore.logger.log(Level.ERROR, "Custom holiday reward \"" + holidayName + "\" loaded!");
            }
        }
    }

    public BasicReward parseReward(Map.Entry<String, JsonElement> reward) {
        ArrayList<IRewardType> rewards = new ArrayList<IRewardType>();
        JsonObject rewardElements = reward.getValue().getAsJsonObject();
        int chance = 0;
        for (Map.Entry rewardElement : rewardElements.entrySet()) {
            if (((String)rewardElement.getKey()).equalsIgnoreCase("chance")) {
                chance = ((JsonElement)rewardElement.getValue()).getAsInt();
                continue;
            }
            if (((String)rewardElement.getKey()).equalsIgnoreCase("dependencies")) {
                boolean gameversion = false;
                for (Map.Entry dependencies : ((JsonElement)rewardElement.getValue()).getAsJsonObject().entrySet()) {
                    if (((String)dependencies.getKey()).equalsIgnoreCase("mod")) {
                        if (Loader.isModLoaded((String)((JsonElement)dependencies.getValue()).getAsString())) continue;
                        return null;
                    }
                    if (!((String)dependencies.getKey()).equalsIgnoreCase("mcVersion") || !MinecraftServer.func_71276_C().func_71249_w().equalsIgnoreCase(((JsonElement)dependencies.getValue()).getAsString())) continue;
                    gameversion = true;
                }
                if (gameversion) continue;
                return null;
            }
            try {
                JsonArray rewardTypes = ((JsonElement)rewardElement.getValue()).getAsJsonArray();
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Item")) {
                    this.loadItemReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Block")) {
                    this.loadBlockReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Message")) {
                    this.loadMessageReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Command")) {
                    this.loadCommandReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Entity")) {
                    this.loadEntityReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Experience")) {
                    this.loadExperienceReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Potion")) {
                    this.loadPotionReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Schematic")) {
                    this.loadSchematicReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Sound")) {
                    this.loadSoundReward(rewardTypes, rewards);
                    continue;
                }
                if (!((String)rewardElement.getKey()).equalsIgnoreCase("Chest")) continue;
                this.loadChestReward(rewardTypes, rewards);
            }
            catch (Exception ex) {
                CCubesCore.logger.log(Level.ERROR, "Failed to load a custom reward for some reason. I will try better next time.");
            }
        }
        return new BasicReward(reward.getKey(), chance, rewards.toArray(new IRewardType[rewards.size()]));
    }

    public List<IRewardType> loadItemReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<ItemPart> items = new ArrayList<ItemPart>();
        for (JsonElement fullelement : rawReward) {
            ItemPart stack;
            String itemInfo = fullelement.getAsJsonObject().get("item").getAsJsonObject().get("id").getAsString();
            JsonObject element = fullelement.getAsJsonObject().get("item").getAsJsonObject();
            if (itemInfo.contains(":")) {
                String mod = itemInfo.substring(0, itemInfo.indexOf(":"));
                String name = itemInfo.substring(itemInfo.indexOf(":") + 1);
                int id = Item.func_150891_b((Item)GameRegistry.findItem((String)mod, (String)name));
                element.getAsJsonObject().addProperty("id", (Number)id);
            }
            try {
                String jsonEdited = this.removedKeyQuotes(element.toString());
                NBTBase nbtbase = JsonToNBT.func_150315_a((String)jsonEdited);
                if (!(nbtbase instanceof NBTTagCompound)) {
                    CCubesCore.logger.log(Level.ERROR, "Failed to convert the JSON to NBT for: " + element.toString());
                    continue;
                }
                ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)nbtbase));
                if (itemstack == null) {
                    CCubesCore.logger.log(Level.ERROR, "Failed to create an itemstack from the JSON of: " + jsonEdited + " and the NBT of: " + ((NBTTagCompound)nbtbase).toString());
                    continue;
                }
                stack = new ItemPart(itemstack);
            }
            catch (NBTException e1) {
                CCubesCore.logger.log(Level.ERROR, e1.getMessage());
                continue;
            }
            if (fullelement.getAsJsonObject().has("delay")) {
                stack.setDelay(fullelement.getAsJsonObject().get("delay").getAsInt());
            }
            items.add(stack);
        }
        rewards.add(new ItemRewardType(items.toArray(new ItemPart[items.size()])));
        return rewards;
    }

    public List<IRewardType> loadBlockReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        for (JsonElement element : rawReward) {
            int x = element.getAsJsonObject().get("XOffSet").getAsInt();
            int y = element.getAsJsonObject().get("YOffSet").getAsInt();
            int z = element.getAsJsonObject().get("ZOffSet").getAsInt();
            String mod = element.getAsJsonObject().get("Block").getAsString().substring(0, element.getAsJsonObject().get("Block").getAsString().indexOf(":"));
            String blockName = element.getAsJsonObject().get("Block").getAsString().substring(element.getAsJsonObject().get("Block").getAsString().indexOf(":") + 1);
            Block block = GameRegistry.findBlock((String)mod, (String)blockName);
            boolean falling = element.getAsJsonObject().get("Falling").getAsBoolean();
            OffsetBlock offBlock = new OffsetBlock(x, y, z, block, falling);
            if (element.getAsJsonObject().has("delay")) {
                offBlock.setDealy(element.getAsJsonObject().get("delay").getAsInt());
            }
            if (element.getAsJsonObject().has("RelativeToPlayer")) {
                offBlock.setRelativeToPlayer(element.getAsJsonObject().get("RelativeToPlayer").getAsBoolean());
            }
            blocks.add(offBlock);
        }
        rewards.add(new BlockRewardType(blocks.toArray(new OffsetBlock[blocks.size()])));
        return rewards;
    }

    public List<IRewardType> loadMessageReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<MessagePart> msgs = new ArrayList<MessagePart>();
        for (JsonElement element : rawReward) {
            MessagePart message = new MessagePart(element.getAsJsonObject().get("message").getAsString());
            if (element.getAsJsonObject().has("delay")) {
                message.setDelay(element.getAsJsonObject().get("delay").getAsInt());
            }
            if (element.getAsJsonObject().has("serverWide")) {
                message.setServerWide(element.getAsJsonObject().get("serverWide").getAsBoolean());
            }
            if (element.getAsJsonObject().has("range")) {
                message.setRange(element.getAsJsonObject().get("range").getAsInt());
            }
            msgs.add(message);
        }
        rewards.add(new MessageRewardType(msgs.toArray(new MessagePart[msgs.size()])));
        return rewards;
    }

    public List<IRewardType> loadCommandReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<CommandPart> commands = new ArrayList<CommandPart>();
        for (JsonElement element : rawReward) {
            CommandPart command = new CommandPart(element.getAsJsonObject().get("command").getAsString());
            if (element.getAsJsonObject().has("delay")) {
                command.setDelay(element.getAsJsonObject().get("delay").getAsInt());
            }
            commands.add(command);
        }
        rewards.add(new CommandRewardType(commands.toArray(new CommandPart[commands.size()])));
        return rewards;
    }

    public List<IRewardType> loadEntityReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<EntityPart> entities = new ArrayList<EntityPart>();
        for (JsonElement element : rawReward) {
            EntityPart ent;
            try {
                String jsonEdited = this.removedKeyQuotes(element.getAsJsonObject().get("entity").getAsJsonObject().toString());
                NBTBase nbtbase = JsonToNBT.func_150315_a((String)jsonEdited);
                if (!(nbtbase instanceof NBTTagCompound)) {
                    CCubesCore.logger.log(Level.ERROR, "Failed to convert the JSON to NBT for: " + element.toString());
                    continue;
                }
                ent = new EntityPart((NBTTagCompound)nbtbase);
            }
            catch (Exception e1) {
                CCubesCore.logger.log(Level.ERROR, "The Entiy loading failed for a custom reward!");
                CCubesCore.logger.log(Level.ERROR, "-------------------------------------------");
                e1.printStackTrace();
                continue;
            }
            if (element.getAsJsonObject().has("delay")) {
                ent.setDelay(element.getAsJsonObject().get("delay").getAsInt());
            }
            entities.add(ent);
        }
        rewards.add(new EntityRewardType(entities.toArray(new EntityPart[entities.size()])));
        return rewards;
    }

    public List<IRewardType> loadExperienceReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<ExpirencePart> exp = new ArrayList<ExpirencePart>();
        for (JsonElement element : rawReward) {
            ExpirencePart exppart = new ExpirencePart(element.getAsJsonObject().get("experienceAmount").getAsInt());
            if (element.getAsJsonObject().has("delay")) {
                exppart.setDelay(element.getAsJsonObject().get("delay").getAsInt());
            }
            if (element.getAsJsonObject().has("numberOfOrbs")) {
                exppart.setNumberofOrbs(element.getAsJsonObject().get("numberOfOrbs").getAsInt());
            }
            exp.add(exppart);
        }
        rewards.add(new ExperienceRewardType(exp.toArray(new ExpirencePart[exp.size()])));
        return rewards;
    }

    public List<IRewardType> loadPotionReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<PotionPart> potionEffects = new ArrayList<PotionPart>();
        for (JsonElement element : rawReward) {
            PotionPart exppart = new PotionPart(new PotionEffect(element.getAsJsonObject().get("potionid").getAsInt(), element.getAsJsonObject().get("duration").getAsInt() * 20));
            if (element.getAsJsonObject().has("delay")) {
                exppart.setDelay(element.getAsJsonObject().get("delay").getAsInt());
            }
            potionEffects.add(exppart);
        }
        rewards.add(new PotionRewardType(potionEffects.toArray(new PotionPart[potionEffects.size()])));
        return rewards;
    }

    public List<IRewardType> loadSoundReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<SoundPart> sounds = new ArrayList<SoundPart>();
        for (JsonElement element : rawReward) {
            SoundPart sound = new SoundPart(element.getAsJsonObject().get("sound").getAsString());
            if (element.getAsJsonObject().has("delay")) {
                sound.setDelay(element.getAsJsonObject().get("delay").getAsInt());
            }
            if (element.getAsJsonObject().has("serverWide")) {
                sound.setServerWide(element.getAsJsonObject().get("serverWide").getAsBoolean());
            }
            if (element.getAsJsonObject().has("range")) {
                sound.setRange(element.getAsJsonObject().get("range").getAsInt());
            }
            sounds.add(sound);
        }
        rewards.add(new SoundRewardType(sounds.toArray(new SoundPart[sounds.size()])));
        return rewards;
    }

    private void addCustomSounds() {
        JsonElement soundsJson;
        File soundsFile;
        try {
            soundsFile = new File(CCubesCore.class.getResource("/assets/chancecubes/sounds.json").toURI());
            soundsJson = json.parse((Reader)new FileReader(soundsFile));
        }
        catch (Exception e) {
            CCubesCore.logger.log(Level.ERROR, "Failed to load the sounds file from chance cubes..... what was the dev thinking?");
            e.printStackTrace();
            return;
        }
        for (File f : new File(this.folder + "/Sounds").listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".ogg"))) {
            String fileShortName = f.getName().substring(0, f.getName().indexOf(46));
            JsonObject event = new JsonObject();
            event.addProperty("category", "master");
            JsonArray sounds = new JsonArray();
            JsonObject sound = new JsonObject();
            sound.addProperty("name", fileShortName);
            sound.addProperty("stream", Boolean.valueOf(true));
            sounds.add((JsonElement)sound);
            event.add("sounds", (JsonElement)sounds);
            soundsJson.getAsJsonObject().add(fileShortName, (JsonElement)event);
            try {
                FileUtils.copyFile((File)f, (File)new File(CCubesCore.class.getResource("/assets/chancecubes/sounds/" + f.getName()).toURI()));
            }
            catch (Exception e) {
                CCubesCore.logger.log(Level.ERROR, "Failed to copy a sound file");
                e.printStackTrace();
            }
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(soundsFile);
            OutputStreamWriter writer = new OutputStreamWriter(outputStream);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            writer.append(gson.toJson(soundsJson));
            writer.close();
            outputStream.close();
        }
        catch (IOException ex) {
            CCubesCore.logger.log(Level.ERROR, "Could not write to json file for the account settings");
        }
    }

    public List<IRewardType> loadChestReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList items = Lists.newArrayList();
        for (JsonElement element : rawReward) {
            JsonObject obj = element.getAsJsonObject();
            if (obj.has("item") && obj.has("chance")) {
                int meta = 0;
                if (obj.has("meta")) {
                    meta = obj.get("meta").getAsInt();
                }
                int amountMin = 0;
                if (obj.has("amountMin")) {
                    amountMin = obj.get("amountMin").getAsInt();
                }
                int amountMax = 8;
                if (obj.has("amountMax")) {
                    amountMax = obj.get("amountMax").getAsInt();
                }
                items.add(new ChestChanceItem(obj.get("item").getAsString(), meta, obj.get("chance").getAsInt(), amountMin, amountMax));
                continue;
            }
            CCubesCore.logger.log(Level.ERROR, "A chest reward failed to load do to missing params");
        }
        rewards.add(new ChestRewardType(items.toArray(new ChestChanceItem[items.size()])));
        return rewards;
    }

    public List<IRewardType> loadSchematicReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        for (JsonElement element : rawReward) {
            Schematic schem = null;
            try {
                schem = this.parseSchematic(element.getAsJsonObject().get("fileName").getAsString(), false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (schem == null) {
                CCubesCore.logger.log(Level.ERROR, "Failed to load the schematic of " + element.getAsJsonObject().get("fileName").getAsString() + ". It seems to be dead :(");
                continue;
            }
            int multiplier = 0;
            if (element.getAsJsonObject().has("delay")) {
                multiplier = element.getAsJsonObject().get("delay").getAsInt();
            }
            int i = 0;
            short halfLength = (short)(schem.length / 2);
            short halfWidth = (short)(schem.width / 2);
            for (int yy = 0; yy < schem.height; ++yy) {
                for (int zz = 0; zz < schem.length; ++zz) {
                    for (int xx = 0; xx < schem.width; ++xx) {
                        Block b;
                        int j = schem.blocks[i];
                        if (j < 0) {
                            j = 128 + (128 + j);
                        }
                        if ((b = Block.func_149729_e((int)j)) != Blocks.field_150350_a) {
                            boolean falling = false;
                            if (element.getAsJsonObject().has("falling")) {
                                falling = element.getAsJsonObject().get("falling").getAsBoolean();
                            }
                            OffsetBlock block = new OffsetBlock(halfWidth - xx, yy, halfLength - zz, b, falling);
                            if (element.getAsJsonObject().has("RelativeToPlayer")) {
                                block.setRelativeToPlayer(element.getAsJsonObject().get("RelativeToPlayer").getAsBoolean());
                            }
                            block.setDealy(i * multiplier);
                            block.setData(schem.data[i]);
                            blocks.add(block);
                        }
                        ++i;
                    }
                }
            }
            if (schem.tileentities == null) continue;
            for (int i1 = 0; i1 < schem.tileentities.func_74745_c(); ++i1) {
                NBTTagCompound nbttagcompound4 = schem.tileentities.func_150305_b(i1);
                TileEntity tileentity = TileEntity.func_145827_c((NBTTagCompound)nbttagcompound4);
                if (tileentity == null) continue;
                boolean falling = false;
                if (element.getAsJsonObject().has("falling")) {
                    falling = element.getAsJsonObject().get("falling").getAsBoolean();
                }
                OffsetTileEntity block = new OffsetTileEntity(tileentity.field_145851_c, tileentity.field_145848_d, tileentity.field_145849_e, tileentity, falling);
                if (element.getAsJsonObject().has("RelativeToPlayer")) {
                    block.setRelativeToPlayer(element.getAsJsonObject().get("RelativeToPlayer").getAsBoolean());
                }
                block.setDealy(i1 * multiplier);
                block.setData(schem.data[i1]);
                blocks.add(block);
            }
        }
        rewards.add(new BlockRewardType(blocks.toArray(new OffsetBlock[blocks.size()])));
        return rewards;
    }

    public Schematic parseSchematic(String name, boolean hardcoded) throws IOException {
        FileInputStream is;
        if (!name.contains(".schematic")) {
            name = name + ".schematic";
        }
        if (hardcoded) {
            is = new FileInputStream(new File(this.source.getAbsolutePath() + "/assets/chancecubes/schematics/" + name));
        } else {
            File schematic = new File(this.folder.getParentFile().getAbsolutePath() + "/CustomRewards/Schematics/" + name);
            is = new FileInputStream(schematic);
        }
        NBTTagCompound nbtdata = CompressedStreamTools.func_74796_a((InputStream)is);
        short width = nbtdata.func_74765_d("Width");
        short height = nbtdata.func_74765_d("Height");
        short length = nbtdata.func_74765_d("Length");
        byte[] blocks = nbtdata.func_74770_j("Blocks");
        byte[] data = nbtdata.func_74770_j("Data");
        NBTTagList tileentities = nbtdata.func_150295_c("TileEntities", 10);
        ((InputStream)is).close();
        return new Schematic(tileentities, width, height, length, blocks, data);
    }

    public String removedKeyQuotes(String raw) {
        int secondQuote;
        StringBuilder sb = new StringBuilder(raw.toString());
        int index = 0;
        while ((index = sb.indexOf("\"", index)) != -1 && (secondQuote = sb.indexOf("\"", index + 1)) != -1) {
            if (sb.charAt(secondQuote + 1) == ':') {
                sb.deleteCharAt(index);
                sb.delete(secondQuote - 1, secondQuote);
                index = secondQuote;
                continue;
            }
            ++index;
        }
        return sb.toString();
    }

    public List<String> getRewardsFiles() {
        ArrayList files = Lists.newArrayList();
        for (File f : this.folder.listFiles()) {
            if (!f.isFile() || !f.getName().substring(f.getName().indexOf(".")).equalsIgnoreCase(".json")) continue;
            files.add(f.getName());
        }
        return files;
    }

    public List<String> getRewardsFromFile(String file) {
        JsonElement fileJson;
        ArrayList rewards = Lists.newArrayList();
        File rewardsFile = new File(this.folder.getPath() + "\\" + file);
        try {
            fileJson = json.parse((Reader)new FileReader(rewardsFile));
        }
        catch (Exception e) {
            CCubesCore.logger.log(Level.ERROR, "Unable to parse the file " + rewardsFile.getName() + ". Skipping file loading.");
            return null;
        }
        for (Map.Entry reward : fileJson.getAsJsonObject().entrySet()) {
            rewards.add(reward.getKey());
        }
        return rewards;
    }

    public List<String> getReward(String file, String rewardName) {
        JsonElement fileJson;
        ArrayList rewardinfo = Lists.newArrayList();
        File rewardsFile = new File(this.folder.getPath() + "\\" + file);
        try {
            fileJson = json.parse((Reader)new FileReader(rewardsFile));
        }
        catch (Exception e) {
            CCubesCore.logger.log(Level.ERROR, "Unable to parse the file " + rewardsFile.getName() + ". Skipping file loading.");
            return null;
        }
        for (Map.Entry reward : fileJson.getAsJsonObject().entrySet()) {
            JsonObject rewardElements = ((JsonElement)reward.getValue()).getAsJsonObject();
            for (Map.Entry rewardElement : rewardElements.entrySet()) {
                if (((String)rewardElement.getKey()).equalsIgnoreCase("chance")) continue;
                rewardinfo.add(rewardElement.getKey());
            }
        }
        return rewardinfo;
    }

    public List<String> getRewardType(String file, String s, String type) {
        JsonElement fileJson;
        ArrayList rewardinfo = Lists.newArrayList();
        File rewardsFile = new File(this.folder.getPath() + "\\" + file);
        try {
            fileJson = json.parse((Reader)new FileReader(rewardsFile));
        }
        catch (Exception e) {
            CCubesCore.logger.log(Level.ERROR, "Unable to parse the file " + rewardsFile.getName() + ". Skipping file loading.");
            return null;
        }
        for (Map.Entry reward : fileJson.getAsJsonObject().entrySet()) {
            JsonObject rewardElements = ((JsonElement)reward.getValue()).getAsJsonObject();
            for (Map.Entry rewardElement : rewardElements.entrySet()) {
                if (!((String)rewardElement.getKey()).equalsIgnoreCase(type)) continue;
                JsonArray rewardTypeArray = ((JsonElement)rewardElement.getValue()).getAsJsonArray();
                for (int i = 0; i < rewardTypeArray.size(); ++i) {
                    rewardinfo.add(rewardTypeArray.get(i).toString());
                }
            }
        }
        return rewardinfo;
    }

    public int compareDates(Calendar first, Calendar second) {
        int fm = first.get(2);
        int sm = second.get(2);
        int fd = first.get(5);
        int sd = second.get(5);
        if (fm < sm) {
            return 1;
        }
        if (fm == sm) {
            return fd == sd ? 0 : (fd < sm ? 1 : -1);
        }
        return -1;
    }

    public class Schematic {
        public NBTTagList tileentities;
        public short width;
        public short height;
        public short length;
        public byte[] blocks;
        public byte[] data;

        public Schematic(NBTTagList tileentities, short width, short height, short length, byte[] blocks, byte[] data) {
            this.tileentities = tileentities;
            this.width = width;
            this.height = height;
            this.length = length;
            this.blocks = blocks;
            this.data = data;
        }
    }
}

