/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.rewardparts;

import chanceCubes.blocks.BlockFallingCustom;
import chanceCubes.config.CCubesSettings;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class OffsetBlock {
    protected boolean relativeToPlayer = false;
    public int xOff;
    public int yOff;
    public int zOff;
    protected byte data = 0;
    protected boolean falling;
    protected int delay = 0;
    protected Block block;
    protected boolean causeUpdate = false;

    public OffsetBlock(int x, int y, int z, Block b, boolean falling) {
        this.xOff = x;
        this.yOff = y;
        this.zOff = z;
        this.block = b;
        this.falling = falling;
    }

    public OffsetBlock(int x, int y, int z, Block b, boolean falling, int delay) {
        this.xOff = x;
        this.yOff = y;
        this.zOff = z;
        this.block = b;
        this.falling = falling;
        this.delay = delay;
    }

    public void spawnInWorld(final World world, final int x, final int y, final int z) {
        if (!this.falling) {
            if (this.delay != 0) {
                Task task = new Task("Delayed_Block_At_(" + this.xOff + "," + this.yOff + "," + this.zOff + ")", this.delay){

                    @Override
                    public void callback() {
                        OffsetBlock.this.placeInWorld(world, x, y, z, true);
                    }
                };
                Scheduler.scheduleTask(task);
            } else {
                this.placeInWorld(world, x, y, z, true);
            }
        } else if (this.delay != 0) {
            Task task = new Task("Falling_Block_At_(" + this.xOff + "," + this.yOff + "," + this.zOff + ")", this.delay){

                @Override
                public void callback() {
                    OffsetBlock.this.spawnFallingBlock(world, x, y, z);
                }
            };
            Scheduler.scheduleTask(task);
        } else {
            this.spawnFallingBlock(world, x, y, z);
        }
    }

    protected void spawnFallingBlock(World world, int x, int y, int z) {
        double yy = (double)(y + this.yOff + CCubesSettings.dropHeight) + 0.5 >= 256.0 ? 255.0 : (double)(y + this.yOff + CCubesSettings.dropHeight) + 0.5;
        for (int yyy = (int)yy; yyy >= y + this.yOff; --yyy) {
            world.func_147468_f(x + this.xOff, yyy, z + this.zOff);
        }
        BlockFallingCustom entityfallingblock = new BlockFallingCustom(world, (double)(x + this.xOff) + 0.5, yy, (double)(z + this.zOff) + 0.5, this.block, this.data, y + this.yOff, this);
        world.func_72838_d((Entity)entityfallingblock);
    }

    public void setDealy(int delay) {
        this.delay = delay;
    }

    public void setData(byte d) {
        this.data = d;
    }

    public OffsetBlock setRelativeToPlayer(boolean relative) {
        this.relativeToPlayer = relative;
        return this;
    }

    public boolean isRelativeToPlayer() {
        return this.relativeToPlayer;
    }

    public int getDelay() {
        return this.delay;
    }

    public OffsetBlock setCausesBlockUpdate(boolean flag) {
        this.causeUpdate = flag;
        return this;
    }

    public void placeInWorld(World world, int x, int y, int z, boolean offset) {
        int xx = x;
        int yy = y;
        int zz = z;
        if (offset) {
            xx += this.xOff;
            yy += this.yOff;
            zz += this.zOff;
        }
        world.func_147465_d(xx, yy, zz, this.block, (int)this.data, this.causeUpdate ? 3 : 2);
        Block bSurface = world.func_147439_a(xx, yy - 1, zz);
        world.func_72908_a((double)((float)xx + 0.5f), (double)((float)yy + 0.5f), (double)((float)zz + 0.5f), bSurface.field_149762_H.func_150496_b(), (bSurface.field_149762_H.func_150497_c() + 1.0f) / 2.0f, bSurface.field_149762_H.func_150494_d() * 0.5f);
    }
}

