/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.items.tools;

import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.AOEHarvestTool;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.tools.TinkerTools;

public class LumberAxe
extends AOEHarvestTool {
    static Material[] materials = new Material[]{Material.field_151575_d, Material.field_151582_l, Material.field_151594_q, Material.field_151570_A, Material.field_151572_C};

    public LumberAxe() {
        super(0, 1, 1);
        this.func_77655_b("InfiTool.LumberAxe");
    }

    @Override
    protected Material[] getEffectiveMaterials() {
        return materials;
    }

    @Override
    protected String getHarvestType() {
        return "axe";
    }

    @Override
    public float getRepairCost() {
        return 4.0f;
    }

    @Override
    public float getDurabilityModifier() {
        return 2.5f;
    }

    @Override
    public boolean func_150894_a(ItemStack itemstack, World world, Block block, int x, int y, int z, EntityLivingBase player) {
        if (block != null && block.func_149688_o() == Material.field_151584_j) {
            return false;
        }
        return AbilityHelper.onBlockChanged(itemstack, world, block, x, y, z, player, this.random);
    }

    @Override
    public float breakSpeedModifier() {
        return 0.4f;
    }

    @Override
    public float stoneboundModifier() {
        return 216.0f;
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        if (!stack.func_77942_o() || player.func_70093_af()) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        World world = player.field_70170_p;
        Block wood = world.func_147439_a(x, y, z);
        if (wood == null) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        if ((wood.isWood((IBlockAccess)world, x, y, z) || wood.func_149688_o() == Material.field_151583_m) && this.detectTree(world, x, y, z, wood)) {
            NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
            int meta = world.func_72805_g(x, y, z);
            this.breakTree(world, x, y, z, x, y, z, stack, tags, wood, meta, player);
            return true;
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }

    private boolean detectTree(World world, int x, int y, int z, Block wood) {
        int height = y;
        boolean foundTop = false;
        do {
            Block block;
            if ((block = world.func_147439_a(x, ++height, z)) == wood) continue;
            --height;
            foundTop = true;
        } while (!foundTop);
        int numLeaves = 0;
        if (height - y < 50) {
            for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
                for (int yPos = height - 1; yPos <= height + 1; ++yPos) {
                    for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                        Block leaves = world.func_147439_a(xPos, yPos, zPos);
                        if (leaves == null || !leaves.isLeaves((IBlockAccess)world, xPos, yPos, zPos)) continue;
                        ++numLeaves;
                    }
                }
            }
        }
        return numLeaves > 3;
    }

    private void breakTree(World world, int x, int y, int z, int xStart, int yStart, int zStart, ItemStack stack, NBTTagCompound tags, Block bID, int meta, EntityPlayer player) {
        for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int yPos = y; yPos <= y + 1; ++yPos) {
                for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                    float localHardness;
                    Block localBlock;
                    if (tags.func_74767_n("Broken") || bID != (localBlock = world.func_147439_a(xPos, yPos, zPos))) continue;
                    int localMeta = world.func_72805_g(xPos, yPos, zPos);
                    int hlvl = localBlock.getHarvestLevel(localMeta);
                    float f = localHardness = localBlock == null ? Float.MAX_VALUE : localBlock.func_149712_f(world, xPos, yPos, zPos);
                    if (hlvl > tags.func_74762_e("HarvestLevel") || localHardness < 0.0f) continue;
                    boolean cancelHarvest = false;
                    for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                        if (!mod.beforeBlockBreak(this, stack, xPos, yPos, zPos, (EntityLivingBase)player)) continue;
                        cancelHarvest = true;
                    }
                    BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(x, y, z, world, localBlock, localMeta, player);
                    event.setCanceled(cancelHarvest);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    cancelHarvest = event.isCanceled();
                    int xDist = xPos - xStart;
                    int yDist = yPos - yStart;
                    int zDist = zPos - zStart;
                    if (9 * xDist * xDist + yDist * yDist + 9 * zDist * zDist >= 2500) continue;
                    if (cancelHarvest) {
                        this.breakTree(world, xPos, yPos, zPos, xStart, yStart, zStart, stack, tags, bID, meta, player);
                        continue;
                    }
                    if (localBlock != bID || localMeta % 4 != meta % 4) continue;
                    if (!player.field_71075_bZ.field_75098_d) {
                        localBlock.func_149636_a(world, player, x, y, z, localMeta);
                        this.func_150894_a(stack, world, localBlock, xPos, yPos, zPos, (EntityLivingBase)player);
                    }
                    world.func_147468_f(xPos, yPos, zPos);
                    if (world.field_72995_K) continue;
                    this.breakTree(world, xPos, yPos, zPos, xStart, yStart, zStart, stack, tags, bID, meta, player);
                }
            }
        }
    }

    @Override
    public Item getHeadItem() {
        return TinkerTools.broadAxeHead;
    }

    @Override
    public Item getHandleItem() {
        return TinkerTools.toughRod;
    }

    @Override
    public Item getAccessoryItem() {
        return TinkerTools.largePlate;
    }

    @Override
    public Item getExtraItem() {
        return TinkerTools.toughBinding;
    }

    @Override
    public int getPartAmount() {
        return 4;
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_lumberaxe_head";
            }
            case 1: {
                return "_lumberaxe_head_broken";
            }
            case 2: {
                return "_lumberaxe_handle";
            }
            case 3: {
                return "_lumberaxe_shield";
            }
            case 4: {
                return "_lumberaxe_binding";
            }
        }
        return "";
    }

    @Override
    public String getEffectSuffix() {
        return "_lumberaxe_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "lumberaxe";
    }

    @Override
    public int durabilityTypeAccessory() {
        return 2;
    }

    @Override
    public int durabilityTypeExtra() {
        return 1;
    }
}

