/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.item.filters;

import cofh.api.energy.IEnergyContainerItem;
import com.rwtema.extrautils.LogHelper;
import com.rwtema.extrautils.asm.RemoteCallFactory;
import com.rwtema.extrautils.item.filters.Matcher;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.BlockDispenser;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.RegistrySimple;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.FluidStack;

public class AdvancedNodeUpgrades {
    public static HashMap<String, Matcher> matcherMap = new HashMap();
    public static ArrayList<Matcher> entryList = new ArrayList();
    public static Matcher nullMatcher = new Matcher("Default", false){

        @Override
        public boolean matchFluid(FluidStack fluid) {
            return true;
        }

        @Override
        public boolean matchItem(ItemStack fluid) {
            return true;
        }
    };

    public static Matcher getMatcher(ItemStack itemStack) {
        Matcher matcher;
        if (itemStack.func_77942_o() && (matcher = matcherMap.get(itemStack.func_77978_p().func_74779_i("Matcher"))) != null) {
            return matcher;
        }
        return nullMatcher;
    }

    public static Matcher nextEntry(ItemStack itemStack, boolean next) {
        NBTTagCompound tags;
        Matcher matcher;
        int i = 0;
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if ((matcher = matcherMap.get((tags = itemStack.func_77978_p()).func_74779_i("Matcher"))) != null) {
            i = matcher.index;
        }
        do {
            if (next) {
                if (++i < entryList.size()) continue;
                i = 0;
                continue;
            }
            if (--i >= 0) continue;
            i = entryList.size() - 1;
        } while (!(matcher = entryList.get(i)).isSelectable());
        tags.func_74778_a("Matcher", matcher.name);
        return matcher;
    }

    public static void addEntry(Matcher matcher) {
        String entry2 = matcher.name;
        matcher.index = entryList.size();
        entryList.add(matcher);
        matcherMap.put(entry2, matcher);
    }

    static {
        AdvancedNodeUpgrades.addEntry(nullMatcher);
        Matcher.MatcherItem m = new Matcher.MatcherItem("Block"){

            @Override
            protected boolean matchItem(Item item) {
                return item instanceof ItemBlock;
            }
        };
        AdvancedNodeUpgrades.addEntry(m);
        AdvancedNodeUpgrades.addEntry(new Matcher.InverseMatch("Item", m));
        AdvancedNodeUpgrades.addEntry(new Matcher.MatcherItem("HasSubTypes"){

            @Override
            protected boolean matchItem(Item item) {
                return item.func_77614_k();
            }
        });
        AdvancedNodeUpgrades.addEntry(new Matcher("StackSize1"){

            @Override
            public boolean matchItem(ItemStack item) {
                return item.func_77976_d() == 1;
            }
        });
        AdvancedNodeUpgrades.addEntry(new Matcher("StackSize64"){

            @Override
            public boolean matchItem(ItemStack item) {
                return item.func_77976_d() == 64;
            }
        });
        AdvancedNodeUpgrades.addEntry(new Matcher.MatcherOreDic("ore"));
        AdvancedNodeUpgrades.addEntry(new Matcher.MatcherOreDic("ingot"));
        AdvancedNodeUpgrades.addEntry(new Matcher.MatcherOreDic("nugget"));
        AdvancedNodeUpgrades.addEntry(new Matcher.MatcherOreDic("block"));
        AdvancedNodeUpgrades.addEntry(new Matcher.MatcherOreDic("gem"));
        AdvancedNodeUpgrades.addEntry(new Matcher.MatcherOreDic("dust"));
        AdvancedNodeUpgrades.addEntry(new Matcher.MatcherItem("EnergyItem"){

            @Override
            public boolean matchItem(ItemStack item) {
                return super.matchItem(item) && ((IEnergyContainerItem)item.func_77973_b()).getMaxEnergyStored(item) != 0;
            }

            @Override
            protected boolean matchItem(Item item) {
                return item instanceof IEnergyContainerItem;
            }
        });
        AdvancedNodeUpgrades.addEntry(new Matcher.MatcherItem("EnergyItemEmpty"){

            @Override
            public boolean matchItem(ItemStack item) {
                return super.matchItem(item) && ((IEnergyContainerItem)item.func_77973_b()).getMaxEnergyStored(item) > 0 && ((IEnergyContainerItem)item.func_77973_b()).getEnergyStored(item) == 0;
            }

            @Override
            protected boolean matchItem(Item item) {
                return item instanceof IEnergyContainerItem;
            }
        });
        AdvancedNodeUpgrades.addEntry(new Matcher.MatcherItem("EnergyItem<50"){

            @Override
            public boolean matchItem(ItemStack item) {
                if (!super.matchItem(item)) {
                    return false;
                }
                IEnergyContainerItem energyContainerItem = (IEnergyContainerItem)item.func_77973_b();
                int maxEnergyStored = energyContainerItem.getMaxEnergyStored(item);
                return maxEnergyStored > 0 && energyContainerItem.getEnergyStored(item) <= maxEnergyStored >> 1;
            }

            @Override
            protected boolean matchItem(Item item) {
                return item instanceof IEnergyContainerItem;
            }
        });
        AdvancedNodeUpgrades.addEntry(new Matcher.MatcherItem("EnergyItemFull"){

            @Override
            public boolean matchItem(ItemStack item) {
                if (!super.matchItem(item)) {
                    return false;
                }
                IEnergyContainerItem energyContainerItem = (IEnergyContainerItem)item.func_77973_b();
                int maxEnergyStored = energyContainerItem.getMaxEnergyStored(item);
                return maxEnergyStored != 0 && energyContainerItem.getEnergyStored(item) == maxEnergyStored;
            }

            @Override
            protected boolean matchItem(Item item) {
                return item instanceof IEnergyContainerItem;
            }
        });
        AdvancedNodeUpgrades.addEntry(new Matcher.MatcherItem("Food"){

            @Override
            protected boolean matchItem(Item item) {
                return item instanceof ItemFood;
            }
        });
        AdvancedNodeUpgrades.addEntry(new Matcher("Smeltable"){

            @Override
            public boolean matchItem(ItemStack item) {
                return FurnaceRecipes.func_77602_a().func_151395_a(item) != null;
            }
        });
        if (RemoteCallFactory.pulverizer != null) {
            AdvancedNodeUpgrades.addEntry(new Matcher("Pulverizer"){

                @Override
                public boolean matchItem(ItemStack item) {
                    return RemoteCallFactory.pulverizer.evaluate(item);
                }
            });
        }
        AdvancedNodeUpgrades.addEntry(new Matcher("Enchanted"){

            @Override
            public boolean matchItem(ItemStack item) {
                return item.func_77948_v();
            }
        });
        AdvancedNodeUpgrades.addEntry(new Matcher("Enchantable"){

            @Override
            public boolean matchItem(ItemStack item) {
                return item.func_77956_u();
            }
        });
        AdvancedNodeUpgrades.addEntry(new Matcher("HasContainerItem"){

            @Override
            public boolean matchItem(ItemStack item) {
                return item.func_77973_b().hasContainerItem(item);
            }
        });
        AdvancedNodeUpgrades.addEntry(new Matcher("DurabilityBarShown"){

            @Override
            public boolean matchItem(ItemStack item) {
                return item.func_77973_b().showDurabilityBar(item);
            }
        });
        AdvancedNodeUpgrades.addEntry(new Matcher("DurabilityBarFull"){

            @Override
            public boolean matchItem(ItemStack stack) {
                Item item = stack.func_77973_b();
                return item.showDurabilityBar(stack) && item.getDurabilityForDisplay(stack) <= 0.0;
            }
        });
        AdvancedNodeUpgrades.addEntry(new Matcher("DurabilityBar<90", false){

            @Override
            public boolean matchItem(ItemStack stack) {
                Item item = stack.func_77973_b();
                return item.showDurabilityBar(stack) && item.getDurabilityForDisplay(stack) >= 0.5;
            }
        });
        AdvancedNodeUpgrades.addEntry(new Matcher("DurabilityBar<50", false){

            @Override
            public boolean matchItem(ItemStack stack) {
                Item item = stack.func_77973_b();
                return item.showDurabilityBar(stack) && item.getDurabilityForDisplay(stack) >= 0.5;
            }
        });
        AdvancedNodeUpgrades.addEntry(new Matcher("DurabilityBar<10", false){

            @Override
            public boolean matchItem(ItemStack stack) {
                Item item = stack.func_77973_b();
                return item.showDurabilityBar(stack) && item.getDurabilityForDisplay(stack) >= 0.9;
            }
        });
        AdvancedNodeUpgrades.addEntry(new Matcher("DurabilityBarEmpty"){

            @Override
            public boolean matchItem(ItemStack stack) {
                Item item = stack.func_77973_b();
                return item.showDurabilityBar(stack) && item.getDurabilityForDisplay(stack) >= 1.0;
            }
        });
        AdvancedNodeUpgrades.addEntry(new Matcher("HasDisplayName", false){

            @Override
            public boolean matchItem(ItemStack stack) {
                return stack.func_82837_s();
            }
        });
        AdvancedNodeUpgrades.addEntry(new Matcher("Repairable"){

            @Override
            public boolean matchItem(ItemStack stack) {
                Item item = stack.func_77973_b();
                return item.isRepairable();
            }
        });
        AdvancedNodeUpgrades.addEntry(new Matcher.MatcherItem("HasDispenserBehaviour"){

            @Override
            public boolean matchItem(Item item) {
                return ((RegistrySimple)BlockDispenser.field_149943_a).func_148741_d((Object)item);
            }
        });
        AdvancedNodeUpgrades.addEntry(new Matcher.MatcherItem("Plantable"){

            @Override
            protected boolean matchItem(Item item) {
                return item instanceof IPlantable;
            }
        });
        if (LogHelper.isDeObf) {
            StringBuilder builder = new StringBuilder();
            for (Matcher matcher : entryList) {
                builder.append('\n');
                builder.append(matcher.unlocalizedName);
                builder.append("=");
                builder.append(matcher.name);
                builder.append(".exe");
            }
            LogHelper.info(builder.toString(), new Object[0]);
        }
    }
}

