/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.modintegration;

import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.ExtraUtilsMod;
import com.rwtema.extrautils.IClientCode;
import com.rwtema.extrautils.ILoading;
import com.rwtema.extrautils.modintegration.TConCastingRecipeUnsensitive;
import com.rwtema.extrautils.modintegration.TConEvents;
import com.rwtema.extrautils.modintegration.TConTextureResourcePackBedrockium;
import com.rwtema.extrautils.modintegration.TConTextureResourcePackMagicWood;
import com.rwtema.extrautils.modintegration.TConTextureResourcePackUnstableIngot;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.ListIterator;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.client.TConstructClientRegistry;
import tconstruct.library.crafting.CastingRecipe;
import tconstruct.library.crafting.FluidType;
import tconstruct.library.crafting.LiquidCasting;
import tconstruct.library.crafting.ModifyBuilder;
import tconstruct.library.crafting.Smeltery;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.modifier.ItemModifier;
import tconstruct.library.tools.DynamicToolPart;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.IPattern;
import tconstruct.modifiers.tools.ModExtraModifier;
import tconstruct.smeltery.TinkerSmeltery;
import tconstruct.tools.TinkerTools;
import tconstruct.util.config.PHConstruct;
import tconstruct.weaponry.TinkerWeaponry;

public class TConIntegration
implements ILoading {
    public static final TConIntegration instance = new TConIntegration();
    public static Fluid unstable;
    public static Fluid bedrock;

    public void addBedrockiumMaterial() {
        if (ExtraUtils.bedrockiumBlock == null || ExtraUtils.bedrockium == null) {
            ExtraUtils.tcon_bedrock_material_id = -1;
            return;
        }
        int id = ExtraUtils.tcon_bedrock_material_id;
        if (id <= 0) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("Id", id);
        String name = "Bedrockium";
        tag.func_74778_a("Name", "Bedrockium");
        tag.func_74778_a("localizationString", "material.extrautils.bedrockium");
        tag.func_74768_a("Durability", 7500);
        tag.func_74768_a("MiningSpeed", 800);
        tag.func_74768_a("HarvestLevel", 7);
        tag.func_74768_a("Attack", 4);
        tag.func_74776_a("HandleModifier", 1.75f);
        tag.func_74768_a("Reinforced", 0);
        tag.func_74776_a("Bow_ProjectileSpeed", 3.0f);
        tag.func_74768_a("Bow_DrawSpeed", 200);
        tag.func_74776_a("Projectile_Mass", 40.0f);
        tag.func_74776_a("Projectile_Fragility", 0.4f);
        tag.func_74778_a("Style", EnumChatFormatting.BLACK.toString());
        tag.func_74768_a("Color", 0xFFFFFF);
        FMLInterModComms.sendMessage((String)"TConstruct", (String)"addMaterial", (NBTTagCompound)tag);
        FluidRegistry.registerFluid((Fluid)bedrock);
        FluidType.registerFluidType((String)bedrock.getName(), (Block)ExtraUtils.bedrockiumBlock, (int)0, (int)850, (Fluid)bedrock, (boolean)true);
        Smeltery.addMelting((ItemStack)new ItemStack((Block)ExtraUtils.bedrockiumBlock, 1), (Block)ExtraUtils.bedrockiumBlock, (int)0, (int)850, (FluidStack)new FluidStack(bedrock, 1296));
        Smeltery.addMelting((ItemStack)new ItemStack((Item)ExtraUtils.bedrockium, 1, 0), (Block)ExtraUtils.bedrockiumBlock, (int)0, (int)850, (FluidStack)new FluidStack(bedrock, 144));
        ItemStack ingotcast = new ItemStack(TinkerSmeltery.metalPattern, 1, 0);
        TConstructRegistry.getBasinCasting().addCastingRecipe(new ItemStack((Block)ExtraUtils.bedrockiumBlock, 1), new FluidStack(bedrock, 1296), null, true, 100);
        TConstructRegistry.getTableCasting().addCastingRecipe(new ItemStack((Item)ExtraUtils.bedrockium, 1), new FluidStack(bedrock, 144), ingotcast, false, 50);
        tag = new NBTTagCompound();
        tag.func_74778_a("FluidName", bedrock.getName());
        tag.func_74768_a("MaterialId", id);
        FMLInterModComms.sendMessage((String)"TConstruct", (String)"addPartCastingMaterial", (NBTTagCompound)tag);
        tag = new NBTTagCompound();
        tag.func_74768_a("MaterialId", id);
        tag.func_74782_a("Item", (NBTBase)new ItemStack((Item)ExtraUtils.bedrockium, 1, 0).func_77955_b(new NBTTagCompound()));
        tag.func_74768_a("Value", 2);
        FMLInterModComms.sendMessage((String)"TConstruct", (String)"addMaterialItem", (NBTTagCompound)tag);
        ExtraUtilsMod.proxy.exectuteClientCode(new IClientCode(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void exectuteClientCode() {
                new TConTextureResourcePackBedrockium("Bedrockium").register();
            }
        });
    }

    public void addMagicWoodMaterial() {
        if (ExtraUtils.decorative1 == null) {
            ExtraUtils.tcon_magical_wood_id = -1;
            return;
        }
        int id = ExtraUtils.tcon_magical_wood_id;
        if (id <= 0) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("Id", id);
        String name = "MagicWood";
        tag.func_74778_a("Name", "MagicWood");
        tag.func_74778_a("localizationString", "material.extrautils.magicwood");
        tag.func_74768_a("Durability", 97);
        tag.func_74768_a("MiningSpeed", 150);
        tag.func_74768_a("HarvestLevel", 1);
        tag.func_74768_a("Attack", 0);
        tag.func_74776_a("HandleModifier", 1.0f);
        tag.func_74768_a("Reinforced", 0);
        tag.func_74776_a("Bow_ProjectileSpeed", 3.0f);
        tag.func_74768_a("Bow_DrawSpeed", 18);
        tag.func_74776_a("Projectile_Mass", 0.69f);
        tag.func_74776_a("Projectile_Fragility", 0.5f);
        tag.func_74778_a("Style", EnumChatFormatting.YELLOW.toString());
        tag.func_74768_a("Color", 7690273);
        FMLInterModComms.sendMessage((String)"TConstruct", (String)"addMaterial", (NBTTagCompound)tag);
        ItemStack itemstack = new ItemStack((Block)ExtraUtils.decorative1, 1, 8);
        tag = new NBTTagCompound();
        tag.func_74768_a("MaterialId", id);
        NBTTagCompound item = new NBTTagCompound();
        itemstack.func_77955_b(item);
        tag.func_74782_a("Item", (NBTBase)item);
        tag.func_74768_a("Value", 2);
        FMLInterModComms.sendMessage((String)"TConstruct", (String)"addPartBuilderMaterial", (NBTTagCompound)tag);
        tag = new NBTTagCompound();
        tag.func_74768_a("MaterialId", id);
        tag.func_74768_a("Value", 2);
        item = new NBTTagCompound();
        itemstack.func_77955_b(item);
        tag.func_74782_a("Item", (NBTBase)item);
        FMLInterModComms.sendMessage((String)"TConstruct", (String)"addMaterialItem", (NBTTagCompound)tag);
        ExtraUtilsMod.proxy.exectuteClientCode(new IClientCode(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void exectuteClientCode() {
                new TConTextureResourcePackMagicWood("MagicWood").register();
            }
        });
    }

    public void addUnstableMaterial() {
        if (ExtraUtils.unstableIngot == null || ExtraUtils.decorative1 == null) {
            ExtraUtils.tcon_unstable_material_id = -1;
            return;
        }
        final int id = ExtraUtils.tcon_unstable_material_id;
        if (id <= 0) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("Id", id);
        String name = "unstableIngot";
        final ToolMaterial mat = new ToolMaterial("unstableIngot", "material.extrautils.unstableIngot", 4, 100, 700, 2, 0.6f, 4, 0.0f, EnumChatFormatting.WHITE.toString(), 0xFFFFFF);
        TConstructRegistry.addtoolMaterial((int)id, (ToolMaterial)mat);
        TConstructRegistry.addDefaultToolPartMaterial((int)id);
        TConstructRegistry.addBowMaterial((int)id, (int)109, (float)1.0f);
        TConstructRegistry.addArrowMaterial((int)id, (float)2.4f, (float)0.0f);
        ExtraUtilsMod.proxy.exectuteClientCode(new IClientCode(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void exectuteClientCode() {
                if (FMLCommonHandler.instance().getSide().isClient()) {
                    TConstructClientRegistry.addMaterialRenderMapping((int)id, (String)"tinker", (String)mat.name().toLowerCase(), (boolean)true);
                }
            }
        });
        FluidRegistry.registerFluid((Fluid)unstable);
        FluidType.registerFluidType((String)unstable.getName(), (Block)ExtraUtils.decorative1, (int)5, (int)850, (Fluid)unstable, (boolean)true);
        Smeltery.addMelting((ItemStack)new ItemStack((Block)ExtraUtils.decorative1, 1, 5), (Block)ExtraUtils.decorative1, (int)5, (int)850, (FluidStack)new FluidStack(unstable, 648));
        Smeltery.addMelting((ItemStack)new ItemStack(ExtraUtils.unstableIngot, 1, 0), (Block)ExtraUtils.decorative1, (int)5, (int)850, (FluidStack)new FluidStack(unstable, 72));
        Smeltery.addMelting((ItemStack)new ItemStack(ExtraUtils.unstableIngot, 1, 1), (Block)ExtraUtils.decorative1, (int)5, (int)850, (FluidStack)new FluidStack(unstable, 8));
        Smeltery.addMelting((ItemStack)new ItemStack(ExtraUtils.unstableIngot, 1, 2), (Block)ExtraUtils.decorative1, (int)5, (int)850, (FluidStack)new FluidStack(unstable, 144));
        TConstructRegistry.getBasinCasting().addCastingRecipe(new ItemStack((Block)ExtraUtils.decorative1, 1, 5), new FluidStack(unstable, 1296), null, true, 100);
        LinkedList<CastingRecipe> newRecipies = new LinkedList<CastingRecipe>();
        for (CastingRecipe recipe : TConstructRegistry.getTableCasting().getCastingRecipes()) {
            if (recipe.castingMetal.getFluid() != TinkerSmeltery.moltenIronFluid || recipe.cast == null || !(recipe.cast.func_77973_b() instanceof IPattern) || !(recipe.getResult().func_77973_b() instanceof DynamicToolPart)) continue;
            newRecipies.add(recipe);
        }
        FluidType ft = FluidType.getFluidType((Fluid)unstable);
        for (CastingRecipe recipe : newRecipies) {
            ItemStack output = recipe.getResult().func_77946_l();
            output.func_77964_b(id);
            FluidStack liquid2 = new FluidStack(unstable, recipe.castingMetal.amount);
            TConstructRegistry.getTableCasting().addCastingRecipe(output, liquid2, recipe.cast, recipe.consumeCast, recipe.coolTime);
            Smeltery.addMelting((FluidType)ft, (ItemStack)output, (int)0, (int)(liquid2.amount / 2));
        }
        tag = new NBTTagCompound();
        tag.func_74768_a("MaterialId", id);
        tag.func_74782_a("Item", (NBTBase)new ItemStack(ExtraUtils.unstableIngot, 1, 0).func_77955_b(new NBTTagCompound()));
        tag.func_74768_a("Value", 2);
        FMLInterModComms.sendMessage((String)"TConstruct", (String)"addMaterialItem", (NBTTagCompound)tag);
        tag = new NBTTagCompound();
        tag.func_74768_a("MaterialId", id);
        tag.func_74782_a("Item", (NBTBase)new ItemStack(ExtraUtils.unstableIngot, 1, 2).func_77955_b(new NBTTagCompound()));
        tag.func_74768_a("Value", 2);
        FMLInterModComms.sendMessage((String)"TConstruct", (String)"addMaterialItem", (NBTTagCompound)tag);
        ExtraUtilsMod.proxy.exectuteClientCode(new IClientCode(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void exectuteClientCode() {
                new TConTextureResourcePackUnstableIngot("unstableIngot").register();
            }
        });
    }

    @Override
    public void init() {
        this.addBedrockiumMaterial();
        this.addUnstableMaterial();
        this.addMagicWoodMaterial();
        this.addModifiers();
    }

    public void addModifiers() {
        ModifyBuilder.registerModifier((ItemModifier)new ModExtraModifier(new ItemStack[]{new ItemStack((Item)ExtraUtils.soul, 1, 0)}, "XUSoul"));
    }

    @Override
    public void preInit() {
    }

    @Override
    public void postInit() {
        if (PHConstruct.alternativeBoltRecipe) {
            return;
        }
        LiquidCasting tb = TConstructRegistry.getTableCasting();
        ListIterator<TConCastingRecipeUnsensitive> iterator = tb.getCastingRecipes().listIterator();
        while (iterator.hasNext()) {
            int materialID;
            CastingRecipe castingRecipe = (CastingRecipe)iterator.next();
            if (castingRecipe == null || castingRecipe.getClass() != CastingRecipe.class || castingRecipe.output == null || castingRecipe.output.func_77973_b() != TinkerWeaponry.partBolt || castingRecipe.cast == null || castingRecipe.cast.func_77973_b() != TinkerTools.toolRod || (materialID = ToolBuilder.instance.getMaterialID(castingRecipe.cast)) <= 0) continue;
            if (materialID == ExtraUtils.tcon_unstable_material_id) {
                iterator.set(new TConCastingRecipeUnsensitive(castingRecipe));
            }
            if (materialID != ExtraUtils.tcon_bedrock_material_id) continue;
            iterator.set(new TConCastingRecipeUnsensitive(castingRecipe));
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new TConEvents());
        unstable = new Fluid("molten.unstableIngots").setDensity(3000).setViscosity(6000).setTemperature(1300);
        bedrock = new Fluid("molten.bedrockiumIngots").setDensity(3000).setViscosity(6000).setTemperature(1300);
    }
}

