/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import cpw.mods.fml.common.registry.GameRegistry;
import gcewing.lighting.BaseMod;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BaseContainerBlock<TE extends TileEntity>
extends BlockContainer
implements BaseMod.IBlock {
    static Random random = new Random();
    public int renderID = 0;
    Class<? extends TileEntity> tileEntityClass = null;
    protected String[] iconNames = null;
    protected IIcon[] icons;

    public BaseContainerBlock(Material material) {
        this(material, null);
    }

    public BaseContainerBlock(Material material, Class<TE> clazz) {
        super(material);
        this.tileEntityClass = clazz;
        if (clazz != null) {
            try {
                GameRegistry.registerTileEntity(clazz, (String)clazz.getName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static IIcon getIcon(Block block, IIconRegister iIconRegister, String string) {
        if (string.indexOf(":") < 0) {
            String string2 = block.getClass().getPackage().getName().replace(".", "_");
            string = string2 + ":" + string;
        }
        return iIconRegister.func_94245_a(string);
    }

    protected IIcon getIcon(IIconRegister iIconRegister, String string) {
        return BaseContainerBlock.getIcon((Block)this, iIconRegister, string);
    }

    public static IIcon[] getIcons(Block block, IIconRegister iIconRegister, String ... stringArray) {
        IIcon[] iIconArray = new IIcon[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            iIconArray[i] = BaseContainerBlock.getIcon(block, iIconRegister, stringArray[i]);
        }
        return iIconArray;
    }

    protected IIcon[] getIcons(IIconRegister iIconRegister, String ... stringArray) {
        return BaseContainerBlock.getIcons((Block)this, iIconRegister, stringArray);
    }

    public void func_149651_a(IIconRegister iIconRegister) {
        if (this.iconNames != null) {
            this.icons = this.getIcons(iIconRegister, this.iconNames);
        } else {
            super.func_149651_a(iIconRegister);
            this.icons = new IIcon[]{this.field_149761_L};
        }
    }

    public void setIconNames(String ... stringArray) {
        this.iconNames = stringArray;
    }

    public void setPrefixedIconNames(String string, String ... stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = string + "-" + stringArray[i];
        }
        this.setIconNames(stringArray2);
    }

    public int func_149645_b() {
        return this.renderID;
    }

    @Override
    public void setRenderType(int n) {
        this.renderID = n;
    }

    @Override
    public String getQualifiedRendererClassName() {
        String string = this.getRendererClassName();
        if (string != null) {
            string = this.getClass().getPackage().getName() + "." + string;
        }
        return string;
    }

    protected String getRendererClassName() {
        return null;
    }

    public boolean func_149686_d() {
        return this.renderID == 0;
    }

    public IIcon func_149691_a(int n, int n2) {
        return this.getLocalIcon(n, n2);
    }

    IIcon getLocalIcon(int n, int n2) {
        if (this.icons != null) {
            if (n < this.icons.length) {
                return this.icons[n];
            }
            return this.icons[this.icons.length - 1];
        }
        return null;
    }

    public boolean hasTileEntity(int n) {
        return this.tileEntityClass != null;
    }

    public TE getTileEntity(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        if (this.func_149716_u()) {
            return (TE)iBlockAccess.func_147438_o(n, n2, n3);
        }
        return null;
    }

    public TileEntity func_149915_a(World world, int n) {
        if (this.tileEntityClass != null) {
            try {
                return this.tileEntityClass.newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    public void func_149726_b(World world, int n, int n2, int n3) {
        super.func_149726_b(world, n, n2, n3);
        TE TE = this.getTileEntity((IBlockAccess)world, n, n2, n3);
        if (TE instanceof BaseMod.ITileEntity) {
            ((BaseMod.ITileEntity)TE).onAddedToWorld();
        }
    }

    public void func_149749_a(World world, int n, int n2, int n3, Block block, int n4) {
        IInventory iInventory;
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof IInventory && (iInventory = (IInventory)tileEntity) != null) {
            for (int i = 0; i < iInventory.func_70302_i_(); ++i) {
                ItemStack itemStack = iInventory.func_70301_a(i);
                if (itemStack == null) continue;
                this.scatterNearby(world, n, n2, n3, itemStack);
            }
        }
        super.func_149749_a(world, n, n2, n3, block, n4);
    }

    public void scatterNearby(World world, int n, int n2, int n3, ItemStack itemStack) {
        float f = random.nextFloat() * 0.8f + 0.1f;
        float f2 = random.nextFloat() * 0.8f + 0.1f;
        float f3 = random.nextFloat() * 0.8f + 0.1f;
        while (itemStack.field_77994_a > 0) {
            int n4 = random.nextInt(21) + 10;
            if (n4 > itemStack.field_77994_a) {
                n4 = itemStack.field_77994_a;
            }
            itemStack.field_77994_a -= n4;
            EntityItem entityItem = new EntityItem(world, (double)((float)n + f), (double)((float)n2 + f2), (double)((float)n3 + f3), new ItemStack(itemStack.func_77973_b(), n4, itemStack.func_77960_j()));
            float f4 = 0.05f;
            entityItem.field_70159_w = (float)random.nextGaussian() * f4;
            entityItem.field_70181_x = (float)random.nextGaussian() * f4 + 0.2f;
            entityItem.field_70179_y = (float)random.nextGaussian() * f4;
            if (itemStack.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
            }
            world.func_72838_d((Entity)entityItem);
        }
    }
}

