/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweaks.util;

import com.google.gson.stream.JsonReader;
import iguanaman.iguanatweaks.IguanaTweaks;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;

public class IguanaJsonReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, Double> readWeightsJson(File file) {
        HashMap<String, Double> weights = new HashMap<String, Double>();
        String objName = null;
        double weight = 0.0;
        JsonReader reader = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            reader = new JsonReader((Reader)new InputStreamReader((InputStream)fis, "UTF-8"));
            reader.beginArray();
            while (reader.hasNext()) {
                reader.beginObject();
                while (reader.hasNext()) {
                    String name = reader.nextName();
                    if (name.equalsIgnoreCase("name")) {
                        objName = reader.nextString();
                        continue;
                    }
                    if (name.equalsIgnoreCase("block")) {
                        IguanaTweaks.log.warn("The \"block\" key in the weights.json file has been deprecated. Change it to \"name\"");
                        objName = reader.nextString();
                        continue;
                    }
                    if (name.equalsIgnoreCase("weight")) {
                        weight = reader.nextDouble();
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                weights.put(objName, weight);
            }
            reader.endArray();
        }
        catch (Exception e) {
            IguanaTweaks.log.error("There was an error in reading the weights.json file");
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    IguanaTweaks.log.error("There was an error in closing the weights.json reader");
                    e.printStackTrace();
                }
            }
        }
        return weights;
    }
}

