/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mekanism.client.sound.IResettableSound;
import mekanism.client.sound.ISoundSource;
import mekanism.client.sound.Sound;
import mekanism.common.base.IHasSound;
import net.minecraft.client.audio.ISound;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class TileSound
extends Sound
implements IResettableSound {
    IHasSound source;
    boolean beginFadeOut;
    boolean donePlaying = true;
    int ticks = 0;
    int fadeIn = 30;
    int fadeOut = 10;
    float baseVolume = 1.0f;

    public TileSound(IHasSound source, ISoundSource values) {
        this(source, values.getSoundLocation(), values.getVolume(), values.getPitch(), values.shouldRepeat(), values.getRepeatDelay(), values.getSoundPosition().xPos, values.getSoundPosition().yPos, values.getSoundPosition().zPos);
    }

    public TileSound(IHasSound source, ISoundSource values, ResourceLocation location) {
        this(source, location, values.getVolume(), values.getPitch(), values.shouldRepeat(), values.getRepeatDelay(), values.getSoundPosition().xPos, values.getSoundPosition().yPos, values.getSoundPosition().zPos);
    }

    public TileSound(IHasSound source, String sound, float volume, float pitch, boolean repeat, int repeatDelay, double x, double y, double z) {
        this(source, sound, volume, pitch, repeat, repeatDelay, x, y, z, ISound.AttenuationType.LINEAR);
    }

    public TileSound(IHasSound source, String sound, float volume, float pitch, boolean repeat, int repeatDelay, double x, double y, double z, ISound.AttenuationType attenuation) {
        this(source, new ResourceLocation(sound), volume, pitch, repeat, repeatDelay, x, y, z, attenuation);
    }

    public TileSound(IHasSound source, ResourceLocation sound, float volume, float pitch, boolean repeat, int repeatDelay, double x, double y, double z) {
        this(source, sound, volume, pitch, repeat, repeatDelay, x, y, z, ISound.AttenuationType.LINEAR);
    }

    public TileSound(IHasSound soundSource, ResourceLocation resource, float volume, float pitch, boolean repeat, int repeatDelay, double x, double y, double z, ISound.AttenuationType attenuation) {
        super(resource, volume, pitch, repeat, repeatDelay, x, y, z, attenuation);
        this.source = soundSource;
        this.sound = resource;
        this.baseVolume = volume;
    }

    public TileSound setFadeIn(int fade) {
        this.fadeIn = Math.min(0, fade);
        return this;
    }

    public TileSound setFadeOut(int fade) {
        this.fadeOut = Math.min(0, fade);
        return this;
    }

    public float getFadeInMultiplier() {
        return this.ticks >= this.fadeIn ? 1.0f : (float)this.ticks / (float)this.fadeIn;
    }

    public float getFadeOutMultiplier() {
        return this.ticks >= this.fadeOut ? 0.0f : (float)(this.fadeOut - this.ticks) / (float)this.fadeOut;
    }

    public void func_73660_a() {
        if (!this.beginFadeOut) {
            if (this.ticks < this.fadeIn) {
                ++this.ticks;
            }
            if (!this.source.shouldPlaySound() || this.source.getSound().sound != this) {
                this.beginFadeOut = true;
                this.ticks = 0;
            }
        } else {
            ++this.ticks;
        }
        float multiplier = this.beginFadeOut ? this.getFadeOutMultiplier() : this.getFadeInMultiplier();
        this.volume = this.baseVolume * multiplier;
        if (multiplier <= 0.0f) {
            this.donePlaying = true;
        }
    }

    public boolean func_147667_k() {
        return this.donePlaying;
    }

    @Override
    public void reset() {
        this.donePlaying = false;
        this.beginFadeOut = false;
        this.volume = this.baseVolume;
        this.ticks = 0;
    }
}

