/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.ArrayList;
import mekanism.api.EnumColor;
import mekanism.api.gas.GasTank;
import mekanism.common.base.ITankManager;
import mekanism.common.util.LangUtils;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class SideData {
    public EnumColor color;
    public String name;
    public int[] availableSlots;
    public EnergyState energyState;

    public SideData(String n, EnumColor colour, int[] slots) {
        this.name = n;
        this.color = colour;
        this.availableSlots = slots;
    }

    public SideData(String n, EnumColor colour, EnergyState state) {
        this.name = n;
        this.color = colour;
        this.energyState = state;
    }

    public String localize() {
        return LangUtils.localize("sideData." + this.name);
    }

    public boolean hasSlot(int ... slots) {
        for (int i : this.availableSlots) {
            for (int slot : slots) {
                if (i != slot) continue;
                return true;
            }
        }
        return false;
    }

    public FluidTankInfo[] getFluidTankInfo(ITankManager manager) {
        Object[] tanks = manager.getTanks();
        ArrayList<FluidTankInfo> infos = new ArrayList<FluidTankInfo>();
        for (int slot : this.availableSlots) {
            if (slot > tanks.length - 1 || !(tanks[slot] instanceof IFluidTank)) continue;
            infos.add(((IFluidTank)tanks[slot]).getInfo());
        }
        return infos.toArray(new FluidTankInfo[0]);
    }

    public GasTank getGasTank(ITankManager manager) {
        Object[] tanks = manager.getTanks();
        if (tanks.length < 1 || !(tanks[0] instanceof GasTank)) {
            return null;
        }
        return (GasTank)tanks[0];
    }

    public static enum EnergyState {
        INPUT,
        OUTPUT,
        OFF;

    }
}

