/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.PacketHandler;
import mekanism.common.content.teleportation.SharedInventory;
import mekanism.common.content.teleportation.SharedInventoryManager;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.CableUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityEntangledBlock
extends TileEntityElectricBlock
implements IFluidHandler,
IGasHandler,
ITubeConnection {
    public SharedInventory sharedInventory;
    public static final EnumSet<ForgeDirection> nothing = EnumSet.noneOf(ForgeDirection.class);

    public TileEntityEntangledBlock() {
        super("Entangled", 0.0);
        this.inventory = new ItemStack[0];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        CableUtils.emit(this);
    }

    public void setInventory(String frequency) {
        this.sharedInventory = SharedInventoryManager.getInventory(frequency);
        this.func_70296_d();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            switch (dataStream.readInt()) {
                case 0: {
                    this.setInventory(PacketHandler.readString(dataStream));
                    return;
                }
            }
        }
        super.handlePacketData(dataStream);
        this.setEnergy(dataStream.readDouble());
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.getEnergy());
        return data;
    }

    @Override
    public EnumSet<ForgeDirection> getOutputtingSides() {
        return this.sharedInventory == null ? nothing : EnumSet.of(ForgeDirection.UP);
    }

    @Override
    public EnumSet<ForgeDirection> getConsumingSides() {
        return this.sharedInventory == null ? nothing : EnumSet.complementOf(EnumSet.of(ForgeDirection.UNKNOWN, ForgeDirection.UP));
    }

    @Override
    public double getMaxOutput() {
        return this.sharedInventory == null ? 0.0 : 1000.0;
    }

    @Override
    public double getEnergy() {
        return this.sharedInventory == null ? 0.0 : this.sharedInventory.getEnergy();
    }

    @Override
    public void setEnergy(double energy) {
        if (this.sharedInventory != null) {
            this.sharedInventory.setEnergy(energy);
        }
    }

    @Override
    public double getMaxEnergy() {
        return this.sharedInventory == null ? 0.0 : this.sharedInventory.getMaxEnergy();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.sharedInventory == null ? 0 : this.sharedInventory.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.sharedInventory == null) {
            return null;
        }
        return this.sharedInventory.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.sharedInventory == null) {
            return null;
        }
        return this.sharedInventory.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.sharedInventory == null ? false : this.sharedInventory.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.sharedInventory == null ? false : this.sharedInventory.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.sharedInventory == null ? new FluidTankInfo[]{} : this.sharedInventory.getTankInfo(from);
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        return this.sharedInventory == null ? 0 : this.sharedInventory.receiveGas(side, stack, doTransfer);
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        return this.sharedInventory == null ? null : this.sharedInventory.drawGas(side, amount, doTransfer);
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        return this.drawGas(side, amount, true);
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return this.sharedInventory == null ? false : this.sharedInventory.canReceiveGas(side, type);
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return this.sharedInventory == null ? false : this.sharedInventory.canDrawGas(side, type);
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return this.sharedInventory != null;
    }
}

