/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import mekanism.api.Coord4D;
import mekanism.common.tile.TileEntitySolarEvaporationBlock;
import mekanism.common.util.PipeUtils;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntitySolarEvaporationValve
extends TileEntitySolarEvaporationBlock
implements IFluidHandler {
    public boolean prevMaster = false;

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            if (this.master != null != this.prevMaster) {
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    Coord4D obj = Coord4D.get(this).getFromSide(side);
                    if (obj.isAirBlock((IBlockAccess)this.field_145850_b) || obj.getTileEntity((IBlockAccess)this.field_145850_b) instanceof TileEntitySolarEvaporationBlock) continue;
                    obj.getBlock((IBlockAccess)this.field_145850_b).onNeighborChange((IBlockAccess)this.field_145850_b, obj.xCoord, obj.yCoord, obj.zCoord, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
            this.prevMaster = this.master != null;
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.master == null ? 0 : this.master.inputTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.master != null && (resource == null || resource.isFluidEqual(this.master.outputTank.getFluid()))) {
            return this.master.outputTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.master != null) {
            return this.master.outputTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.master != null && this.master.hasRecipe(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.master != null && this.master.outputTank.getFluidAmount() > 0;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.master == null) {
            return PipeUtils.EMPTY;
        }
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.master.inputTank), new FluidTankInfo((IFluidTank)this.master.outputTank)};
    }
}

