/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.minetweaker;

import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IFlexibleRecipe;
import buildcraft.api.recipes.IFlexibleRecipeViewable;
import java.util.ArrayList;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.buildcraft.Refinery")
@ModOnly(value={"BuildCraft|Factory"})
public class Refinery {
    @ZenMethod
    public static void addRecipe(ILiquidStack output, int energyPerMB, int ticksPerMB, ILiquidStack input1, @Optional ILiquidStack input2) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, energyPerMB, ticksPerMB, input1, input2));
    }

    @ZenMethod
    public static void remove(ILiquidStack output) {
        Fluid fluid = MineTweakerMC.getLiquidStack((ILiquidStack)output).getFluid();
        ArrayList<IFlexibleRecipe> toRemove = new ArrayList<IFlexibleRecipe>();
        for (IFlexibleRecipe recipe : BuildcraftRecipeRegistry.refinery.getRecipes()) {
            if (!(recipe instanceof IFlexibleRecipeViewable) || ((IFlexibleRecipeViewable)recipe).getOutput() != fluid) continue;
            toRemove.add(recipe);
        }
        for (IFlexibleRecipe recipe : toRemove) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveRecipeAction((IFlexibleRecipe<FluidStack>)recipe));
        }
    }

    private static class RemoveRecipeAction
    implements IUndoableAction {
        private final IFlexibleRecipe<FluidStack> recipe;

        public RemoveRecipeAction(IFlexibleRecipe<FluidStack> recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            BuildcraftRecipeRegistry.refinery.removeRecipe(this.recipe);
        }

        public boolean canUndo() {
            return false;
        }

        public void undo() {
        }

        public String describe() {
            return "Removing refinery recipe for " + ((FluidStack)((IFlexibleRecipeViewable)this.recipe).getOutput()).getLocalizedName();
        }

        public String describeUndo() {
            return "Restoring refinery recipe for " + ((FluidStack)((IFlexibleRecipeViewable)this.recipe).getOutput()).getLocalizedName();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private final ILiquidStack output;
        private final ILiquidStack input1;
        private final ILiquidStack input2;
        private final int energyPerMB;
        private final int ticksPerMB;

        public AddRecipeAction(ILiquidStack output, int energyPerMB, int ticksPerMB, ILiquidStack input1, ILiquidStack input2) {
            this.output = output;
            this.input1 = input1;
            this.input2 = input2;
            this.energyPerMB = energyPerMB;
            this.ticksPerMB = ticksPerMB;
        }

        public void apply() {
            String name = "MineTweaker:" + this.input1.getName() + ":" + this.input2.getName() + ":" + this.output.getName();
            if (this.input2 == null) {
                BuildcraftRecipeRegistry.refinery.addRecipe(name, MineTweakerMC.getLiquidStack((ILiquidStack)this.input1), MineTweakerMC.getLiquidStack((ILiquidStack)this.output), this.energyPerMB, this.ticksPerMB);
            } else {
                BuildcraftRecipeRegistry.refinery.addRecipe(name, MineTweakerMC.getLiquidStack((ILiquidStack)this.input1), MineTweakerMC.getLiquidStack((ILiquidStack)this.input2), MineTweakerMC.getLiquidStack((ILiquidStack)this.output), this.energyPerMB, this.ticksPerMB);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            String name = "MineTweaker:" + this.input1.getName() + ":" + this.input2.getName() + ":" + this.output.getName();
            BuildcraftRecipeRegistry.refinery.removeRecipe(name);
        }

        public String describe() {
            return "Adding refinery recipe for " + this.output;
        }

        public String describeUndo() {
            return "Removing refinery recipe for " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

