/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import openmods.api.IValueReceiver;
import openmods.gui.component.GuiComponentResizable;
import openmods.gui.misc.BoxRenderer;

public class GuiComponentTankLevel
extends GuiComponentResizable {
    private static final BoxRenderer BOX_RENDERER = new BoxRenderer(0, 0);
    private static final int BORDER_COLOR = 0xC6C6C6;
    private FluidStack fluidStack;
    private int capacity;

    public GuiComponentTankLevel(int x, int y, int width, int height, int capacity) {
        super(x, y, width, height);
        this.capacity = capacity;
    }

    @Override
    public void render(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        GuiComponentTankLevel.bindComponentsSheet();
        BOX_RENDERER.render(this, this.x + offsetX, this.y + offsetY, this.width, this.height, 0xC6C6C6);
        if (this.fluidStack == null) {
            return;
        }
        Fluid fluid = this.fluidStack.getFluid();
        if (fluid == null) {
            return;
        }
        minecraft.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        IIcon icon = fluid.getIcon();
        if (icon != null) {
            double percentFull = Math.max(0.0, Math.min(1.0, (double)this.fluidStack.amount / (double)this.capacity));
            double fluidHeight = (double)(this.height - 3) * percentFull;
            int posX = offsetX + this.x;
            int posY = offsetY + this.y;
            float minU = icon.func_94209_e();
            float maxU = icon.func_94212_f();
            float minV = icon.func_94206_g();
            float maxV = icon.func_94210_h();
            tessellator.func_78374_a((double)(posX + 3), (double)(posY + this.height - 3), (double)this.field_73735_i, (double)minU, (double)maxV);
            tessellator.func_78374_a((double)(posX + this.width - 3), (double)(posY + this.height - 3), (double)this.field_73735_i, (double)maxU, (double)maxV);
            tessellator.func_78374_a((double)(posX + this.width - 3), (double)posY + ((double)this.height - fluidHeight), (double)this.field_73735_i, (double)maxU, (double)minV);
            tessellator.func_78374_a((double)(posX + 3), (double)posY + ((double)this.height - fluidHeight), (double)this.field_73735_i, (double)minU, (double)minV);
            tessellator.func_78381_a();
        }
    }

    @Override
    public void renderOverlay(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
    }

    public void setFluid(FluidStack value) {
        this.fluidStack = value;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public IValueReceiver<FluidStack> fluidReceiver() {
        return new IValueReceiver<FluidStack>(){

            @Override
            public void setValue(FluidStack value) {
                GuiComponentTankLevel.this.fluidStack = value;
            }
        };
    }

    public IValueReceiver<Integer> capacityReceiver() {
        return new IValueReceiver<Integer>(){

            @Override
            public void setValue(Integer value) {
                GuiComponentTankLevel.this.capacity = value;
            }
        };
    }
}

