/*
 * Decompiled with CFR 0.152.
 */
package openmods.reflection;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.reflect.Method;
import openmods.reflection.ReflectionHelper;

public class MethodAccess {
    public static <R> Function0<R> create(Class<? extends R> returnCls, Class<?> target, String ... names) {
        return new Function0Impl<R>(returnCls, ReflectionHelper.getMethod(target, names, new Class[0]));
    }

    public static <R, P1> Function1<R, P1> create(Class<? extends R> returnCls, Class<?> target, Class<? extends P1> p1, String ... names) {
        return new Function1Impl(returnCls, ReflectionHelper.getMethod(target, names, p1));
    }

    public static <R, P1, P2> Function2<R, P1, P2> create(Class<? extends R> returnCls, Class<?> target, Class<? extends P1> p1, Class<? extends P2> p2, String ... names) {
        return new Function2Impl(returnCls, ReflectionHelper.getMethod(target, names, p1, p2));
    }

    public static <R, P1, P2, P3> Function3<R, P1, P2, P3> create(Class<? extends R> returnCls, Class<?> target, Class<? extends P1> p1, Class<? extends P2> p2, Class<? extends P3> p3, String ... names) {
        return new Function3Impl(returnCls, ReflectionHelper.getMethod(target, names, p1, p2, p3));
    }

    public static <R, P1, P2, P3, P4> Function4<R, P1, P2, P3, P4> create(Class<? extends R> returnCls, Class<?> target, Class<? extends P1> p1, Class<? extends P2> p2, Class<? extends P3> p3, Class<? extends P4> p4, String ... names) {
        return new Function4Impl(returnCls, ReflectionHelper.getMethod(target, names, p1, p2, p3, p4));
    }

    public static <R, P1, P2, P3, P4, P5> Function5<R, P1, P2, P3, P4, P5> create(Class<? extends R> returnCls, Class<?> target, Class<? extends P1> p1, Class<? extends P2> p2, Class<? extends P3> p3, Class<? extends P4> p4, Class<? extends P5> p5, String ... names) {
        return new Function5Impl(returnCls, ReflectionHelper.getMethod(target, names, p1, p2, p3, p4, p5));
    }

    private static class Function5Impl<R, P1, P2, P3, P4, P5>
    extends FunctionWrap<R>
    implements Function5<R, P1, P2, P3, P4, P5> {
        public Function5Impl(Class<? extends R> returnCls, Method method) {
            super(returnCls, method);
        }

        @Override
        public R call(Object target, P1 p1, P2 p2, P3 p3, P4 p4, P5 p5) {
            return super.call(target, p1, p2, p3, p4, p5);
        }
    }

    public static interface Function5<R, P1, P2, P3, P4, P5> {
        public R call(Object var1, P1 var2, P2 var3, P3 var4, P4 var5, P5 var6);
    }

    private static class Function4Impl<R, P1, P2, P3, P4>
    extends FunctionWrap<R>
    implements Function4<R, P1, P2, P3, P4> {
        public Function4Impl(Class<? extends R> returnCls, Method method) {
            super(returnCls, method);
        }

        @Override
        public R call(Object target, P1 p1, P2 p2, P3 p3, P4 p4) {
            return super.call(target, p1, p2, p3, p4);
        }
    }

    public static interface Function4<R, P1, P2, P3, P4> {
        public R call(Object var1, P1 var2, P2 var3, P3 var4, P4 var5);
    }

    private static class Function3Impl<R, P1, P2, P3>
    extends FunctionWrap<R>
    implements Function3<R, P1, P2, P3> {
        public Function3Impl(Class<? extends R> returnCls, Method method) {
            super(returnCls, method);
        }

        @Override
        public R call(Object target, P1 p1, P2 p2, P3 p3) {
            return super.call(target, p1, p2, p3);
        }
    }

    public static interface Function3<R, P1, P2, P3> {
        public R call(Object var1, P1 var2, P2 var3, P3 var4);
    }

    private static class Function2Impl<R, P1, P2>
    extends FunctionWrap<R>
    implements Function2<R, P1, P2> {
        public Function2Impl(Class<? extends R> returnCls, Method method) {
            super(returnCls, method);
        }

        @Override
        public R call(Object target, P1 p1, P2 p2) {
            return super.call(target, p1, p2);
        }
    }

    public static interface Function2<R, P1, P2> {
        public R call(Object var1, P1 var2, P2 var3);
    }

    private static class Function1Impl<R, P1>
    extends FunctionWrap<R>
    implements Function1<R, P1> {
        public Function1Impl(Class<? extends R> returnCls, Method method) {
            super(returnCls, method);
        }

        @Override
        public R call(Object target, P1 p1) {
            return super.call(target, p1);
        }
    }

    public static interface Function1<R, P1> {
        public R call(Object var1, P1 var2);
    }

    private static class Function0Impl<R>
    extends FunctionWrap<R>
    implements Function0<R> {
        public Function0Impl(Class<? extends R> returnCls, Method method) {
            super(returnCls, method);
        }

        @Override
        public R call(Object target) {
            return super.call(target, new Object[0]);
        }
    }

    public static interface Function0<R> {
        public R call(Object var1);
    }

    private static class FunctionWrap<R>
    implements FunctionVar<R> {
        private final Method method;

        public FunctionWrap(Class<? extends R> returnCls, Method method) {
            this.method = method;
            Preconditions.checkArgument((boolean)returnCls.isAssignableFrom(method.getReturnType()), (String)"Method '%s' has invalid return type", (Object[])new Object[]{method});
        }

        @Override
        public R call(Object target, Object ... args) {
            try {
                return (R)this.method.invoke(target, args);
            }
            catch (Throwable t) {
                throw Throwables.propagate((Throwable)t);
            }
        }
    }

    public static interface FunctionVar<R> {
        public R call(Object var1, Object ... var2);
    }
}

