/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.SortedSet;
import openmods.utils.ByteUtils;
import openmods.utils.io.IStreamReader;
import openmods.utils.io.IStreamWriter;

public class CollectionUtils {
    public static final Random rnd = new Random();

    public static <T> T getFirst(Collection<T> collection) {
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0, (Object)"Collection cannot be empty");
        return collection.iterator().next();
    }

    public static <T> T getRandom(Collection<T> collection) {
        return CollectionUtils.getRandom(collection, rnd);
    }

    public static <T> T getRandom(Collection<T> collection, Random rand) {
        int size = collection.size();
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"Can't select from empty collection");
        if (size == 1) {
            return CollectionUtils.getFirst(collection);
        }
        int randomIndex = rnd.nextInt(size);
        int i = 0;
        for (T obj : collection) {
            if (i == randomIndex) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    public static <T> T getRandom(List<T> list) {
        return CollectionUtils.getRandom(list, rnd);
    }

    public static <T> T getRandom(List<T> list, Random rand) {
        int size = list.size();
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"Can't select from empty list");
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return list.get(0);
        }
        int randomIndex = rnd.nextInt(list.size());
        return list.get(randomIndex);
    }

    public static <T> T getWeightedRandom(Map<T, Integer> collection) {
        int totalWeight = 0;
        Collection<Integer> values = collection.values();
        for (Integer i : values) {
            totalWeight += i.intValue();
        }
        int r = rnd.nextInt(totalWeight);
        for (Map.Entry<T, Integer> entry : collection.entrySet()) {
            if ((r -= entry.getValue().intValue()) > 0) continue;
            return entry.getKey();
        }
        return null;
    }

    public static void readSortedIdList(DataInput input, Collection<Integer> output) {
        int elemCount = ByteUtils.readVLI(input);
        int currentId = 0;
        for (int i = 0; i < elemCount; ++i) {
            output.add(currentId += ByteUtils.readVLI(input));
        }
    }

    public static void writeSortedIdList(DataOutput output, SortedSet<Integer> idList) {
        ByteUtils.writeVLI(output, idList.size());
        int currentId = 0;
        for (Integer id : idList) {
            int delta = id - currentId;
            ByteUtils.writeVLI(output, delta);
            currentId = id;
        }
    }

    public static <D> void readSortedIdMap(DataInput input, Map<Integer, D> output, IStreamReader<D> reader) {
        int elemCount = ByteUtils.readVLI(input);
        int currentId = 0;
        try {
            for (int i = 0; i < elemCount; ++i) {
                D data = reader.readFromStream(input);
                output.put(currentId += ByteUtils.readVLI(input), data);
            }
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public static <D> void writeSortedIdMap(DataOutput output, SortedMap<Integer, D> input, IStreamWriter<D> writer) {
        ByteUtils.writeVLI(output, input.size());
        int currentId = 0;
        try {
            for (Map.Entry<Integer, D> e : input.entrySet()) {
                int id = e.getKey();
                int delta = id - currentId;
                ByteUtils.writeVLI(output, delta);
                writer.writeToStream(e.getValue(), output);
                currentId = id;
            }
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }
}

