/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import openmods.utils.CachedFactory;

public abstract class FieldsSelector {
    private final CachedFactory<Class<?>, Collection<Field>> cache = new CachedFactory<Class<?>, Collection<Field>>(){

        @Override
        protected Collection<Field> create(Class<?> key) {
            return FieldsSelector.this.scanForFields(key);
        }
    };

    protected abstract List<FieldEntry> listFields(Class<?> var1);

    private Collection<Field> scanForFields(Class<?> cls) {
        List<FieldEntry> entries = this.listFields(cls);
        Collections.sort(entries);
        ImmutableList.Builder result = ImmutableList.builder();
        for (FieldEntry entry : entries) {
            Field field = entry.field;
            result.add((Object)field);
            field.setAccessible(true);
        }
        return result.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Field> getFields(Class<?> cls) {
        CachedFactory<Class<?>, Collection<Field>> cachedFactory = this.cache;
        synchronized (cachedFactory) {
            return this.cache.getOrCreate(cls);
        }
    }

    public static class FieldEntry
    implements Comparable<FieldEntry> {
        public final Field field;
        public final int rank;

        public FieldEntry(Field field, int rank) {
            this.field = field;
            this.rank = rank;
        }

        @Override
        public int compareTo(FieldEntry o) {
            int result = Integer.compare(this.rank, o.rank);
            if (result != 0) {
                return result;
            }
            return this.field.getName().compareTo(o.field.getName());
        }
    }
}

