/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.io;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import openmods.utils.ByteUtils;
import openmods.utils.io.INBTSerializer;
import openmods.utils.io.IStreamSerializer;
import openmods.utils.io.IStringSerializer;
import openmods.utils.io.StringConversionException;

public abstract class TypeRW<T>
implements INBTSerializer<T>,
IStreamSerializer<T>,
IStringSerializer<T> {
    public static final TypeRW<Integer> INTEGER = new TypeRW<Integer>(){

        @Override
        public void writeToStream(Integer o, DataOutput output) throws IOException {
            output.writeInt(o);
        }

        @Override
        public Integer readFromStream(DataInput input) throws IOException {
            return input.readInt();
        }

        @Override
        public boolean checkTagType(NBTBase tag) {
            return tag instanceof NBTTagInt;
        }

        @Override
        public Integer readFromNBT(NBTTagCompound tag, String name) {
            return tag.func_74762_e(name);
        }

        @Override
        public void writeToNBT(Integer o, NBTTagCompound tag, String name) {
            tag.func_74768_a(name, o.intValue());
        }

        @Override
        public Integer readFromString(String s) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new StringConversionException("integer", s, e);
            }
        }
    };
    public static final TypeRW<Float> FLOAT = new TypeRW<Float>(){

        @Override
        public Float readFromNBT(NBTTagCompound tag, String name) {
            return Float.valueOf(tag.func_74760_g(name));
        }

        @Override
        public void writeToNBT(Float o, NBTTagCompound tag, String name) {
            tag.func_74776_a(name, o.floatValue());
        }

        @Override
        public boolean checkTagType(NBTBase tag) {
            return tag instanceof NBTTagFloat;
        }

        @Override
        public void writeToStream(Float o, DataOutput output) throws IOException {
            output.writeFloat(o.floatValue());
        }

        @Override
        public Float readFromStream(DataInput input) throws IOException {
            return Float.valueOf(input.readFloat());
        }

        @Override
        public Float readFromString(String s) {
            try {
                return Float.valueOf(Float.parseFloat(s));
            }
            catch (NumberFormatException e) {
                throw new StringConversionException("float", s, e);
            }
        }
    };
    public static final TypeRW<Double> DOUBLE = new TypeRW<Double>(){

        @Override
        public Double readFromNBT(NBTTagCompound tag, String name) {
            return tag.func_74769_h(name);
        }

        @Override
        public void writeToNBT(Double o, NBTTagCompound tag, String name) {
            tag.func_74780_a(name, o.doubleValue());
        }

        @Override
        public boolean checkTagType(NBTBase tag) {
            return tag instanceof NBTTagDouble;
        }

        @Override
        public void writeToStream(Double o, DataOutput output) throws IOException {
            output.writeDouble(o);
        }

        @Override
        public Double readFromStream(DataInput input) throws IOException {
            return input.readDouble();
        }

        @Override
        public Double readFromString(String s) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                throw new StringConversionException("double", s, e);
            }
        }
    };
    public static final TypeRW<String> STRING = new TypeRW<String>(){

        @Override
        public String readFromNBT(NBTTagCompound tag, String name) {
            return tag.func_74779_i(name);
        }

        @Override
        public void writeToNBT(String o, NBTTagCompound tag, String name) {
            tag.func_74778_a(name, o);
        }

        @Override
        public boolean checkTagType(NBTBase tag) {
            return tag instanceof NBTTagString;
        }

        @Override
        public void writeToStream(String o, DataOutput output) throws IOException {
            output.writeUTF(Strings.nullToEmpty((String)o));
        }

        @Override
        public String readFromStream(DataInput input) throws IOException {
            return input.readUTF();
        }

        @Override
        public String readFromString(String s) {
            return s;
        }
    };
    public static final TypeRW<Short> SHORT = new TypeRW<Short>(){

        @Override
        public Short readFromNBT(NBTTagCompound tag, String name) {
            return tag.func_74765_d(name);
        }

        @Override
        public void writeToNBT(Short o, NBTTagCompound tag, String name) {
            tag.func_74777_a(name, o.shortValue());
        }

        @Override
        public boolean checkTagType(NBTBase tag) {
            return tag instanceof NBTTagShort;
        }

        @Override
        public void writeToStream(Short o, DataOutput output) throws IOException {
            output.writeShort(o.shortValue());
        }

        @Override
        public Short readFromStream(DataInput input) throws IOException {
            return input.readShort();
        }

        @Override
        public Short readFromString(String s) {
            try {
                return Short.parseShort(s);
            }
            catch (NumberFormatException e) {
                throw new StringConversionException("short", s, e);
            }
        }
    };
    public static final TypeRW<Byte> BYTE = new TypeRW<Byte>(){

        @Override
        public Byte readFromNBT(NBTTagCompound tag, String name) {
            return tag.func_74771_c(name);
        }

        @Override
        public void writeToNBT(Byte o, NBTTagCompound tag, String name) {
            tag.func_74774_a(name, o.byteValue());
        }

        @Override
        public boolean checkTagType(NBTBase tag) {
            return tag instanceof NBTTagByte;
        }

        @Override
        public void writeToStream(Byte o, DataOutput output) throws IOException {
            output.writeByte(o.byteValue());
        }

        @Override
        public Byte readFromStream(DataInput input) throws IOException {
            return input.readByte();
        }

        @Override
        public Byte readFromString(String s) {
            try {
                return Byte.parseByte(s);
            }
            catch (NumberFormatException e) {
                throw new StringConversionException("byte", s, e);
            }
        }
    };
    public static final TypeRW<Boolean> BOOL = new TypeRW<Boolean>(){

        @Override
        public Boolean readFromNBT(NBTTagCompound tag, String name) {
            return tag.func_74767_n(name);
        }

        @Override
        public void writeToNBT(Boolean o, NBTTagCompound tag, String name) {
            tag.func_74757_a(name, o.booleanValue());
        }

        @Override
        public boolean checkTagType(NBTBase tag) {
            return tag instanceof NBTTagByte;
        }

        @Override
        public void writeToStream(Boolean o, DataOutput output) throws IOException {
            output.writeBoolean(o);
        }

        @Override
        public Boolean readFromStream(DataInput input) throws IOException {
            return input.readBoolean();
        }

        @Override
        public Boolean readFromString(String s) {
            if ((s = s.toLowerCase()).equals("true")) {
                return Boolean.TRUE;
            }
            if (s.equals("false")) {
                return Boolean.FALSE;
            }
            throw new StringConversionException("bool", s);
        }
    };
    public static final TypeRW<Long> LONG = new TypeRW<Long>(){

        @Override
        public Long readFromNBT(NBTTagCompound tag, String name) {
            return tag.func_74763_f(name);
        }

        @Override
        public void writeToNBT(Long o, NBTTagCompound tag, String name) {
            tag.func_74772_a(name, o.longValue());
        }

        @Override
        public boolean checkTagType(NBTBase tag) {
            return tag instanceof NBTTagLong;
        }

        @Override
        public void writeToStream(Long o, DataOutput output) throws IOException {
            output.writeLong(o);
        }

        @Override
        public Long readFromStream(DataInput input) throws IOException {
            return input.readLong();
        }

        @Override
        public Long readFromString(String s) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                throw new StringConversionException("long", s, e);
            }
        }
    };
    public static final TypeRW<byte[]> BYTE_ARRAY = new TypeRW<byte[]>(){

        @Override
        public byte[] readFromString(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeToStream(byte[] o, DataOutput output) throws IOException {
            ByteUtils.writeVLI(output, o.length);
            output.write(o);
        }

        @Override
        public byte[] readFromStream(DataInput input) throws IOException {
            int lenght = ByteUtils.readVLI(input);
            byte[] result = new byte[lenght];
            input.readFully(result);
            return result;
        }

        @Override
        public void writeToNBT(byte[] o, NBTTagCompound tag, String name) {
            tag.func_74773_a(name, o);
        }

        @Override
        public byte[] readFromNBT(NBTTagCompound tag, String name) {
            return tag.func_74770_j(name);
        }

        @Override
        public boolean checkTagType(NBTBase tag) {
            return tag instanceof NBTTagByteArray;
        }
    };
    public static final IStreamSerializer<Integer> VLI_SERIALIZABLE = new IStreamSerializer<Integer>(){

        @Override
        public void writeToStream(Integer o, DataOutput output) {
            ByteUtils.writeVLI(output, o);
        }

        @Override
        public Integer readFromStream(DataInput input) {
            return ByteUtils.readVLI(input);
        }
    };
    public static final IStreamSerializer<Character> CHAR = new IStreamSerializer<Character>(){

        @Override
        public void writeToStream(Character o, DataOutput output) throws IOException {
            output.writeChar(o.charValue());
        }

        @Override
        public Character readFromStream(DataInput input) throws IOException {
            return Character.valueOf(input.readChar());
        }
    };
    public static final Map<Class<?>, TypeRW<?>> UNIVERSAL_SERIALIZERS = ImmutableMap.builder().put(Integer.class, INTEGER).put(Integer.TYPE, INTEGER).put(Boolean.class, BOOL).put(Boolean.TYPE, BOOL).put(Byte.class, BYTE).put(Byte.TYPE, BYTE).put(Double.class, DOUBLE).put(Double.TYPE, DOUBLE).put(Float.class, FLOAT).put(Float.TYPE, FLOAT).put(Long.class, LONG).put(Long.TYPE, LONG).put(Short.class, SHORT).put(Short.TYPE, SHORT).put(String.class, STRING).build();
    public static final Map<Class<?>, IStreamSerializer<?>> STREAM_SERIALIZERS = ImmutableMap.builder().putAll(UNIVERSAL_SERIALIZERS).put(Character.class, CHAR).put(Character.TYPE, CHAR).build();
    public static final Map<Class<?>, INBTSerializer<?>> NBT_SERIALIZERS = ImmutableMap.builder().putAll(UNIVERSAL_SERIALIZERS).build();
    public static final Map<Class<?>, IStringSerializer<?>> STRING_SERIALIZERS = ImmutableMap.builder().putAll(UNIVERSAL_SERIALIZERS).build();
}

